/*
 * Decompiled with CFR 0.152.
 */
package monasca.persister.pipeline;

import com.google.inject.Inject;
import com.google.inject.assistedinject.Assisted;
import monasca.persister.pipeline.event.FlushableHandler;
import monasca.persister.repository.RepoException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ManagedPipeline<T> {
    private static final Logger logger = LoggerFactory.getLogger(ManagedPipeline.class);
    private final FlushableHandler<T> handler;
    private final String threadId;

    @Inject
    public ManagedPipeline(@Assisted FlushableHandler<T> handler, @Assisted String threadId) {
        this.handler = handler;
        this.threadId = threadId;
    }

    public boolean shutdown() throws RepoException {
        logger.info("[{}]: shutdown", (Object)this.threadId);
        try {
            int msgFlushCnt = this.handler.flush();
            return msgFlushCnt > 0;
        }
        catch (RepoException e) {
            logger.error("[{}}: failed to flush repo on shutdown", (Object)this.threadId, (Object)e);
            logger.error("[{}]: pipeline broken. repo unavailable. check that database is running. shutting pipeline down now!", (Object)this.threadId);
            throw e;
        }
    }

    public boolean publishEvent(String msg) throws RepoException {
        try {
            return this.handler.onEvent(msg);
        }
        catch (RepoException e) {
            logger.error("[{}]: failed to handle msg: {}", new Object[]{this.threadId, msg, e});
            logger.error("[{}]: pipeline broken. repo unavailable. check that database is running. shutting pipeline down now!", (Object)this.threadId);
            throw e;
        }
    }
}

