/*
 * Decompiled with CFR 0.152.
 */
package monasca.persister.repository.vertica;

import com.codahale.metrics.Counter;
import com.codahale.metrics.Meter;
import com.codahale.metrics.Timer;
import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import io.dropwizard.setup.Environment;
import java.security.NoSuchAlgorithmException;
import java.sql.SQLException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashSet;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import java.util.TimeZone;
import java.util.TreeMap;
import javax.inject.Inject;
import monasca.common.model.metric.Metric;
import monasca.common.model.metric.MetricEnvelope;
import monasca.persister.configuration.PersisterConfig;
import monasca.persister.pipeline.event.MetricHandler;
import monasca.persister.repository.Repo;
import monasca.persister.repository.vertica.Sha1HashId;
import monasca.persister.repository.vertica.VerticaRepo;
import org.apache.commons.codec.digest.DigestUtils;
import org.skife.jdbi.v2.DBI;
import org.skife.jdbi.v2.PreparedBatch;
import org.skife.jdbi.v2.PreparedBatchPart;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class VerticaMetricRepo
extends VerticaRepo
implements Repo<MetricEnvelope> {
    private static final Logger logger = LoggerFactory.getLogger(VerticaMetricRepo.class);
    public static final int MAX_COLUMN_LENGTH = 255;
    private final SimpleDateFormat simpleDateFormat;
    private static final String TENANT_ID = "tenantId";
    private static final String REGION = "region";
    private final Environment environment;
    private final Cache<Sha1HashId, Sha1HashId> definitionsIdCache;
    private final Cache<Sha1HashId, Sha1HashId> dimensionsIdCache;
    private final Cache<Sha1HashId, Sha1HashId> definitionDimensionsIdCache;
    private final Set<Sha1HashId> definitionIdSet = new HashSet<Sha1HashId>();
    private final Set<Sha1HashId> dimensionIdSet = new HashSet<Sha1HashId>();
    private final Set<Sha1HashId> definitionDimensionsIdSet = new HashSet<Sha1HashId>();
    private static final String SQL_INSERT_INTO_METRICS = "insert into MonMetrics.measurements (definition_dimensions_id, time_stamp, value) values (:definition_dimension_id, :time_stamp, :value)";
    private static final String DEFINITIONS_TEMP_STAGING_TABLE = "(   id BINARY(20) NOT NULL,   name VARCHAR(255) NOT NULL,   tenant_id VARCHAR(255) NOT NULL,   region VARCHAR(255) NOT NULL)";
    private static final String DIMENSIONS_TEMP_STAGING_TABLE = "(    dimension_set_id BINARY(20) NOT NULL,    name VARCHAR(255) NOT NULL,    value VARCHAR(255) NOT NULL)";
    private static final String DEFINITIONS_DIMENSIONS_TEMP_STAGING_TABLE = "(   id BINARY(20) NOT NULL,   definition_id BINARY(20) NOT NULL,    dimension_set_id BINARY(20) NOT NULL )";
    private PreparedBatch metricsBatch;
    private PreparedBatch stagedDefinitionsBatch;
    private PreparedBatch stagedDimensionsBatch;
    private PreparedBatch stagedDefinitionDimensionsBatch;
    private final String definitionsTempStagingTableName;
    private final String dimensionsTempStagingTableName;
    private final String definitionDimensionsTempStagingTableName;
    private final String definitionsTempStagingTableInsertStmt;
    private final String dimensionsTempStagingTableInsertStmt;
    private final String definitionDimensionsTempStagingTableInsertStmt;
    private final Counter metricCounter;
    private final Counter definitionCounter;
    private final Counter dimensionCounter;
    private final Counter definitionDimensionsCounter;
    private final Timer flushTimer;
    public final Meter measurementMeter;
    public final Meter definitionCacheMissMeter;
    public final Meter dimensionCacheMissMeter;
    public final Meter definitionDimensionCacheMissMeter;
    public final Meter definitionCacheHitMeter;
    public final Meter dimensionCacheHitMeter;
    public final Meter definitionDimensionCacheHitMeter;

    @Inject
    public VerticaMetricRepo(DBI dbi, PersisterConfig configuration, Environment environment) throws NoSuchAlgorithmException, SQLException {
        super(dbi);
        logger.debug("Instantiating: " + this.getClass().getName());
        this.simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSS");
        this.simpleDateFormat.setTimeZone(TimeZone.getTimeZone("GMT-0"));
        this.environment = environment;
        String handlerName = String.format("%s[%d]", MetricHandler.class.getName(), new Random().nextInt());
        this.metricCounter = environment.metrics().counter(handlerName + "." + "metrics-added-to-batch-counter");
        this.definitionCounter = environment.metrics().counter(handlerName + "." + "metric-definitions-added-to-batch-counter");
        this.dimensionCounter = environment.metrics().counter(handlerName + "." + "metric-dimensions-added-to-batch-counter");
        this.definitionDimensionsCounter = environment.metrics().counter(handlerName + "." + "metric-definition-dimensions-added-to-batch-counter");
        this.flushTimer = this.environment.metrics().timer(this.getClass().getName() + "." + "flush-timer");
        this.measurementMeter = this.environment.metrics().meter(this.getClass().getName() + "." + "measurement-meter");
        this.definitionCacheMissMeter = this.environment.metrics().meter(this.getClass().getName() + "." + "definition-cache-miss-meter");
        this.dimensionCacheMissMeter = this.environment.metrics().meter(this.getClass().getName() + "." + "dimension-cache-miss-meter");
        this.definitionDimensionCacheMissMeter = this.environment.metrics().meter(this.getClass().getName() + "." + "definition-dimension-cache-miss-meter");
        this.definitionCacheHitMeter = this.environment.metrics().meter(this.getClass().getName() + "." + "definition-cache-hit-meter");
        this.dimensionCacheHitMeter = this.environment.metrics().meter(this.getClass().getName() + "." + "dimension-cache-hit-meter");
        this.definitionDimensionCacheHitMeter = this.environment.metrics().meter(this.getClass().getName() + "." + "definition-dimension-cache-hit-meter");
        this.definitionsIdCache = CacheBuilder.newBuilder().maximumSize((long)configuration.getVerticaMetricRepoConfig().getMaxCacheSize().intValue()).build();
        this.dimensionsIdCache = CacheBuilder.newBuilder().maximumSize((long)configuration.getVerticaMetricRepoConfig().getMaxCacheSize().intValue()).build();
        this.definitionDimensionsIdCache = CacheBuilder.newBuilder().maximumSize((long)configuration.getVerticaMetricRepoConfig().getMaxCacheSize().intValue()).build();
        logger.info("preparing database and building sql statements...");
        String uniqueName = this.toString().replaceAll("\\.", "_").replaceAll("\\@", "_");
        this.definitionsTempStagingTableName = uniqueName + "_staged_definitions";
        logger.debug("temp staging definitions table name: " + this.definitionsTempStagingTableName);
        this.dimensionsTempStagingTableName = uniqueName + "_staged_dimensions";
        logger.debug("temp staging dimensions table name:" + this.dimensionsTempStagingTableName);
        this.definitionDimensionsTempStagingTableName = uniqueName + "_staged_definitions_dimensions";
        logger.debug("temp staging definitionDimensions table name: " + this.definitionDimensionsTempStagingTableName);
        this.definitionsTempStagingTableInsertStmt = "insert into  MonMetrics.Definitions select distinct * from " + this.definitionsTempStagingTableName + " where id not in (select id from MonMetrics.Definitions)";
        logger.debug("definitions insert stmt: " + this.definitionsTempStagingTableInsertStmt);
        this.dimensionsTempStagingTableInsertStmt = "insert into MonMetrics.Dimensions select distinct * from " + this.dimensionsTempStagingTableName + " where dimension_set_id not in (select dimension_set_id from MonMetrics.Dimensions)";
        logger.debug("dimensions insert stmt: " + this.definitionsTempStagingTableInsertStmt);
        this.definitionDimensionsTempStagingTableInsertStmt = "insert into MonMetrics.definitionDimensions select distinct * from " + this.definitionDimensionsTempStagingTableName + " where id not in (select id from MonMetrics.definitionDimensions)";
        logger.debug("definitionDimensions insert stmt: " + this.definitionDimensionsTempStagingTableInsertStmt);
        logger.debug("dropping temp staging tables if they already exist...");
        this.handle.execute("drop table if exists " + this.definitionsTempStagingTableName + " cascade", new Object[0]);
        this.handle.execute("drop table if exists " + this.dimensionsTempStagingTableName + " cascade", new Object[0]);
        this.handle.execute("drop table if exists " + this.definitionDimensionsTempStagingTableName + " cascade", new Object[0]);
        logger.debug("creating temp staging tables...");
        this.handle.execute("create local temp table " + this.definitionsTempStagingTableName + " " + DEFINITIONS_TEMP_STAGING_TABLE + " on commit preserve rows", new Object[0]);
        this.handle.execute("create local temp table " + this.dimensionsTempStagingTableName + " " + DIMENSIONS_TEMP_STAGING_TABLE + " on commit preserve rows", new Object[0]);
        this.handle.execute("create local temp table " + this.definitionDimensionsTempStagingTableName + " " + DEFINITIONS_DIMENSIONS_TEMP_STAGING_TABLE + " on commit preserve rows", new Object[0]);
        this.handle.getConnection().setAutoCommit(false);
        logger.debug("preparing batches...");
        this.metricsBatch = this.handle.prepareBatch(SQL_INSERT_INTO_METRICS);
        this.stagedDefinitionsBatch = this.handle.prepareBatch("insert into " + this.definitionsTempStagingTableName + " values (:id, :name, :tenant_id, :region)");
        this.stagedDimensionsBatch = this.handle.prepareBatch("insert into " + this.dimensionsTempStagingTableName + " values (:dimension_set_id, :name, :value)");
        this.stagedDefinitionDimensionsBatch = this.handle.prepareBatch("insert into " + this.definitionDimensionsTempStagingTableName + " values (:id, :definition_id, :dimension_set_id)");
        logger.debug("opening transaction...");
        this.handle.begin();
        logger.debug("completed database preparations");
        logger.debug(this.getClass().getName() + "is fully instantiated");
    }

    @Override
    public void addToBatch(MetricEnvelope metricEnvelope) {
        Metric metric = metricEnvelope.metric;
        Map meta = metricEnvelope.meta;
        logger.debug("metric: {}", (Object)metric);
        logger.debug("meta: {}", (Object)meta);
        String tenantId = "";
        if (meta.containsKey(TENANT_ID)) {
            tenantId = (String)meta.get(TENANT_ID);
        } else {
            logger.warn("Failed to find tenantId in message envelope meta data. Metric message may be malformed. Setting tenantId to empty string.");
            logger.warn("metric: {}", (Object)metric.toString());
            logger.warn("meta: {}", (Object)meta.toString());
        }
        String region = "";
        if (meta.containsKey(REGION)) {
            region = (String)meta.get(REGION);
        } else {
            logger.warn("Failed to find region in message envelope meta data. Metric message may be malformed. Setting region to empty string.");
            logger.warn("metric: {}", (Object)metric.toString());
            logger.warn("meta: {}", (Object)meta.toString());
        }
        StringBuilder definitionIdStringToHash = new StringBuilder(this.trunc(metric.getName(), 255));
        definitionIdStringToHash.append(this.trunc(tenantId, 255));
        definitionIdStringToHash.append(this.trunc(region, 255));
        byte[] definitionIdSha1Hash = DigestUtils.sha((String)definitionIdStringToHash.toString());
        Sha1HashId definitionSha1HashId = new Sha1HashId(definitionIdSha1Hash);
        this.addDefinitionToBatch(definitionSha1HashId, this.trunc(metric.getName(), 255), this.trunc(tenantId, 255), this.trunc(region, 255));
        this.definitionCounter.inc();
        StringBuilder dimensionIdStringToHash = new StringBuilder();
        Map<String, String> preppedDimMap = this.prepDimensions(metric.getDimensions());
        for (Map.Entry<String, String> entry : preppedDimMap.entrySet()) {
            dimensionIdStringToHash.append(entry.getKey());
            dimensionIdStringToHash.append(entry.getValue());
        }
        byte[] dimensionIdSha1Hash = DigestUtils.sha((String)dimensionIdStringToHash.toString());
        Sha1HashId dimensionsSha1HashId = new Sha1HashId(dimensionIdSha1Hash);
        this.addDimensionsToBatch(dimensionsSha1HashId, preppedDimMap);
        StringBuilder definitionDimensionsIdStringToHash = new StringBuilder(definitionSha1HashId.toHexString());
        definitionDimensionsIdStringToHash.append(dimensionsSha1HashId.toHexString());
        byte[] definitionDimensionsIdSha1Hash = DigestUtils.sha((String)definitionDimensionsIdStringToHash.toString());
        Sha1HashId definitionDimensionsSha1HashId = new Sha1HashId(definitionDimensionsIdSha1Hash);
        this.addDefinitionDimensionToBatch(definitionDimensionsSha1HashId, definitionSha1HashId, dimensionsSha1HashId);
        this.definitionDimensionsCounter.inc();
        String timeStamp = this.simpleDateFormat.format(new Date(metric.getTimestamp()));
        double value = metric.getValue();
        this.addMetricToBatch(definitionDimensionsSha1HashId, timeStamp, value, metric.getValueMeta());
        this.metricCounter.inc();
    }

    public void addMetricToBatch(Sha1HashId defDimsId, String timeStamp, double value, Map<String, String> valueMeta) {
        logger.debug("Adding metric to batch: defDimsId: {}, time: {}, value: {}", new Object[]{defDimsId.toHexString(), timeStamp, value});
        ((PreparedBatchPart)((PreparedBatchPart)this.metricsBatch.add().bind("definition_dimension_id", defDimsId.getSha1Hash())).bind("time_stamp", timeStamp)).bind("value", value);
        this.measurementMeter.mark();
    }

    private void addDefinitionToBatch(Sha1HashId defId, String name, String tenantId, String region) {
        if (this.definitionsIdCache.getIfPresent((Object)defId) == null) {
            this.definitionCacheMissMeter.mark();
            if (!this.definitionIdSet.contains(defId)) {
                logger.debug("Adding definition to batch: defId: {}, name: {}, tenantId: {}, region: {}", new Object[]{defId.toHexString(), name, tenantId, region});
                ((PreparedBatchPart)((PreparedBatchPart)((PreparedBatchPart)this.stagedDefinitionsBatch.add().bind("id", defId.getSha1Hash())).bind("name", name)).bind("tenant_id", tenantId)).bind(REGION, region);
                this.definitionIdSet.add(defId);
            }
        } else {
            this.definitionCacheHitMeter.mark();
        }
    }

    private void addDimensionsToBatch(Sha1HashId dimSetId, Map<String, String> dimMap) {
        if (this.dimensionsIdCache.getIfPresent((Object)dimSetId) == null) {
            this.dimensionCacheMissMeter.mark();
            if (!this.dimensionIdSet.contains(dimSetId)) {
                for (Map.Entry<String, String> entry : dimMap.entrySet()) {
                    String name = entry.getKey();
                    String value = entry.getValue();
                    logger.debug("Adding dimension to batch: dimSetId: {}, name: {}, value: {}", new Object[]{dimSetId.toHexString(), name, value});
                    ((PreparedBatchPart)((PreparedBatchPart)this.stagedDimensionsBatch.add().bind("dimension_set_id", dimSetId.getSha1Hash())).bind("name", name)).bind("value", value);
                }
                this.dimensionIdSet.add(dimSetId);
            }
        } else {
            this.dimensionCacheHitMeter.mark();
        }
    }

    private void addDefinitionDimensionToBatch(Sha1HashId defDimsId, Sha1HashId defId, Sha1HashId dimId) {
        if (this.definitionDimensionsIdCache.getIfPresent((Object)defDimsId) == null) {
            this.definitionDimensionCacheMissMeter.mark();
            if (!this.definitionDimensionsIdSet.contains(defDimsId)) {
                logger.debug("Adding definitionDimension to batch: defDimsId: {}, defId: {}, dimId: {}", new Object[]{defDimsId.toHexString(), defId, dimId});
                ((PreparedBatchPart)((PreparedBatchPart)this.stagedDefinitionDimensionsBatch.add().bind("id", defDimsId.getSha1Hash())).bind("definition_id", defId.getSha1Hash())).bind("dimension_set_id", dimId.getSha1Hash());
                this.definitionDimensionsIdSet.add(defDimsId);
            }
        } else {
            this.definitionDimensionCacheHitMeter.mark();
        }
    }

    @Override
    public int flush(String id) {
        try {
            long startTime = System.currentTimeMillis();
            Timer.Context context = this.flushTimer.time();
            this.executeBatches();
            this.writeRowsFromTempStagingTablesToPermTables();
            this.handle.commit();
            this.handle.begin();
            long endTime = System.currentTimeMillis();
            context.stop();
            logger.debug("Writing measurements, definitions, and dimensions to database took " + (endTime - startTime) / 1000L + " seconds");
            this.updateIdCaches();
        }
        catch (Exception e) {
            logger.error("Failed to write measurements, definitions, or dimensions to database", (Throwable)e);
            if (this.handle.isInTransaction()) {
                this.handle.rollback();
            }
            this.clearTempCaches();
            this.handle.begin();
        }
        return 0;
    }

    private void executeBatches() {
        this.metricsBatch.execute();
        this.stagedDefinitionsBatch.execute();
        this.stagedDimensionsBatch.execute();
        this.stagedDefinitionDimensionsBatch.execute();
    }

    private void updateIdCaches() {
        for (Sha1HashId defId : this.definitionIdSet) {
            this.definitionsIdCache.put((Object)defId, (Object)defId);
        }
        for (Sha1HashId dimId : this.dimensionIdSet) {
            this.dimensionsIdCache.put((Object)dimId, (Object)dimId);
        }
        for (Sha1HashId defDimsId : this.definitionDimensionsIdSet) {
            this.definitionDimensionsIdCache.put((Object)defDimsId, (Object)defDimsId);
        }
        this.clearTempCaches();
    }

    private void writeRowsFromTempStagingTablesToPermTables() {
        this.handle.execute(this.definitionsTempStagingTableInsertStmt, new Object[0]);
        this.handle.execute("truncate table " + this.definitionsTempStagingTableName, new Object[0]);
        this.handle.execute(this.dimensionsTempStagingTableInsertStmt, new Object[0]);
        this.handle.execute("truncate table " + this.dimensionsTempStagingTableName, new Object[0]);
        this.handle.execute(this.definitionDimensionsTempStagingTableInsertStmt, new Object[0]);
        this.handle.execute("truncate table " + this.definitionDimensionsTempStagingTableName, new Object[0]);
    }

    private void clearTempCaches() {
        this.definitionIdSet.clear();
        this.dimensionIdSet.clear();
        this.definitionDimensionsIdSet.clear();
    }

    private Map<String, String> prepDimensions(Map<String, String> dimMap) {
        TreeMap<String, String> newDimMap = new TreeMap<String, String>();
        if (dimMap != null) {
            for (String dimName : dimMap.keySet()) {
                String dimValue;
                if (dimName == null || dimName.isEmpty() || (dimValue = dimMap.get(dimName)) == null || dimValue.isEmpty()) continue;
                newDimMap.put(this.trunc(dimName, 255), this.trunc(dimValue, 255));
                this.dimensionCounter.inc();
            }
        }
        return newDimMap;
    }

    private String trunc(String s, int l) {
        if (s == null) {
            return "";
        }
        if (s.length() <= l) {
            return s;
        }
        String r = s.substring(0, l);
        logger.warn("Input string exceeded max column length. Truncating input string {} to {} chars", (Object)s, (Object)l);
        logger.warn("Resulting string {}", (Object)r);
        return r;
    }
}

