/*
 * Decompiled with CFR 0.152.
 */
package monasca.persister.repository.influxdb;

import com.codahale.metrics.Timer;
import io.dropwizard.setup.Environment;
import monasca.persister.repository.Repo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class InfluxRepo<T>
implements Repo<T> {
    private static final Logger logger = LoggerFactory.getLogger(InfluxRepo.class);
    protected final Timer flushTimer;

    public InfluxRepo(Environment env) {
        this.flushTimer = env.metrics().timer(this.getClass().getName() + ".flush-timer");
    }

    @Override
    public int flush(String id) throws Exception {
        if (this.isBufferEmpty()) {
            logger.debug("[{}]: no msg to be written to influxdb", (Object)id);
            logger.debug("[{}]: returning from flush without flushing", (Object)id);
            return 0;
        }
        return this.writeToRepo(id);
    }

    private int writeToRepo(String id) throws Exception {
        try {
            Timer.Context context = this.flushTimer.time();
            long startTime = System.currentTimeMillis();
            int msgWriteCnt = this.write(id);
            long endTime = System.currentTimeMillis();
            context.stop();
            logger.debug("[{}]: writing to influxdb took {} millis", (Object)id, (Object)(endTime - startTime));
            this.clearBuffers();
            return msgWriteCnt;
        }
        catch (Exception e) {
            logger.error("[{}]: failed to write to influxdb", (Object)id, (Object)e);
            throw e;
        }
    }

    protected abstract boolean isBufferEmpty();

    protected abstract int write(String var1) throws Exception;

    protected abstract void clearBuffers();
}

