/*
 * Decompiled with CFR 0.152.
 */
package monasca.persister.repository.influxdb;

import com.codahale.metrics.Meter;
import com.codahale.metrics.MetricRegistry;
import io.dropwizard.setup.Environment;
import java.util.LinkedList;
import java.util.List;
import monasca.common.model.event.AlarmStateTransitionedEvent;
import monasca.persister.repository.influxdb.InfluxRepo;

public abstract class InfluxAlarmRepo
extends InfluxRepo<AlarmStateTransitionedEvent> {
    protected static final String ALARM_STATE_HISTORY_NAME = "alarm_state_history";
    protected final Meter alarmStateHistoryMeter;
    protected List<AlarmStateTransitionedEvent> alarmStateTransitionedEventList = new LinkedList<AlarmStateTransitionedEvent>();

    public InfluxAlarmRepo(Environment env) {
        super(env);
        this.alarmStateHistoryMeter = env.metrics().meter(MetricRegistry.name(this.getClass(), (String[])new String[]{"alarm_state_history-meter"}));
    }

    @Override
    public void addToBatch(AlarmStateTransitionedEvent alarmStateTransitionedEvent) {
        this.alarmStateTransitionedEventList.add(alarmStateTransitionedEvent);
        this.alarmStateHistoryMeter.mark();
    }

    @Override
    protected void clearBuffers() {
        this.alarmStateTransitionedEventList.clear();
    }

    @Override
    protected boolean isBufferEmpty() {
        return this.alarmStateTransitionedEventList.isEmpty();
    }
}

