/*
 * Decompiled with CFR 0.152.
 */
package monasca.persister.pipeline.event;

import com.codahale.metrics.Counter;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.PropertyNamingStrategy;
import com.google.inject.Inject;
import com.google.inject.assistedinject.Assisted;
import io.dropwizard.setup.Environment;
import java.io.IOException;
import monasca.common.model.metric.MetricEnvelope;
import monasca.persister.configuration.PipelineConfig;
import monasca.persister.pipeline.event.FlushableHandler;
import monasca.persister.repository.Repo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MetricHandler
extends FlushableHandler<MetricEnvelope[]> {
    private static final Logger logger = LoggerFactory.getLogger(MetricHandler.class);
    private final Repo<MetricEnvelope> metricRepo;
    private final Counter metricCounter;

    @Inject
    public MetricHandler(Repo<MetricEnvelope> metricRepo, Environment environment, @Assisted PipelineConfig configuration, @Assisted(value="threadId") String threadId, @Assisted(value="batchSize") int batchSize) {
        super(configuration, environment, threadId, batchSize);
        this.metricRepo = metricRepo;
        this.metricCounter = environment.metrics().counter(this.handlerName + "." + "metrics-added-to-batch-counter");
    }

    @Override
    public int process(String msg) throws IOException {
        MetricEnvelope[] metricEnvelopesArry;
        for (MetricEnvelope metricEnvelope : metricEnvelopesArry = (MetricEnvelope[])this.objectMapper.readValue(msg, MetricEnvelope[].class)) {
            this.processEnvelope(metricEnvelope);
        }
        return metricEnvelopesArry.length;
    }

    private void processEnvelope(MetricEnvelope metricEnvelope) {
        logger.debug("[{}]: [{}:{}] {}", new Object[]{this.threadId, this.getBatchCount(), this.getMsgCount(), metricEnvelope});
        this.metricRepo.addToBatch(metricEnvelope);
        this.metricCounter.inc();
    }

    @Override
    protected void initObjectMapper() {
        this.objectMapper.disable(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES);
        this.objectMapper.enable(DeserializationFeature.ACCEPT_SINGLE_VALUE_AS_ARRAY);
        this.objectMapper.setPropertyNamingStrategy(PropertyNamingStrategy.CAMEL_CASE_TO_LOWER_CASE_WITH_UNDERSCORES);
    }

    @Override
    public int flushRepository() throws Exception {
        return this.metricRepo.flush(this.threadId);
    }
}

