/*
 * Decompiled with CFR 0.152.
 */
package monasca.persister;

import com.google.inject.AbstractModule;
import com.google.inject.Scopes;
import com.google.inject.TypeLiteral;
import com.google.inject.assistedinject.FactoryModuleBuilder;
import io.dropwizard.setup.Environment;
import javax.inject.Singleton;
import monasca.common.model.event.AlarmStateTransitionedEvent;
import monasca.common.model.metric.MetricEnvelope;
import monasca.persister.configuration.PersisterConfig;
import monasca.persister.consumer.KafkaChannel;
import monasca.persister.consumer.KafkaChannelFactory;
import monasca.persister.consumer.KafkaConsumer;
import monasca.persister.consumer.KafkaConsumerFactory;
import monasca.persister.consumer.KafkaConsumerRunnableBasic;
import monasca.persister.consumer.KafkaConsumerRunnableBasicFactory;
import monasca.persister.consumer.ManagedConsumer;
import monasca.persister.consumer.ManagedConsumerFactory;
import monasca.persister.dbi.DBIProvider;
import monasca.persister.pipeline.ManagedPipeline;
import monasca.persister.pipeline.ManagedPipelineFactory;
import monasca.persister.pipeline.event.AlarmStateTransitionedEventHandler;
import monasca.persister.pipeline.event.AlarmStateTransitionedEventHandlerFactory;
import monasca.persister.pipeline.event.MetricHandler;
import monasca.persister.pipeline.event.MetricHandlerFactory;
import monasca.persister.repository.Repo;
import monasca.persister.repository.influxdb.InfluxV9AlarmRepo;
import monasca.persister.repository.influxdb.InfluxV9MetricRepo;
import monasca.persister.repository.influxdb.InfluxV9RepoWriter;
import monasca.persister.repository.vertica.VerticaAlarmRepo;
import monasca.persister.repository.vertica.VerticaMetricRepo;
import org.skife.jdbi.v2.DBI;

public class PersisterModule
extends AbstractModule {
    private static final String VERTICA = "vertica";
    private static final String INFLUXDB = "influxdb";
    private static final String INFLUXDB_V9 = "v9";
    private final PersisterConfig config;
    private final Environment env;

    public PersisterModule(PersisterConfig config, Environment env) {
        this.config = config;
        this.env = env;
    }

    protected void configure() {
        this.bind(PersisterConfig.class).toInstance((Object)this.config);
        this.bind(Environment.class).toInstance((Object)this.env);
        this.install(new FactoryModuleBuilder().implement(MetricHandler.class, MetricHandler.class).build(MetricHandlerFactory.class));
        this.install(new FactoryModuleBuilder().implement(AlarmStateTransitionedEventHandler.class, AlarmStateTransitionedEventHandler.class).build(AlarmStateTransitionedEventHandlerFactory.class));
        this.install(new FactoryModuleBuilder().implement((TypeLiteral)new TypeLiteral<KafkaConsumerRunnableBasic<MetricEnvelope[]>>(){}, (TypeLiteral)new TypeLiteral<KafkaConsumerRunnableBasic<MetricEnvelope[]>>(){}).build((TypeLiteral)new TypeLiteral<KafkaConsumerRunnableBasicFactory<MetricEnvelope[]>>(){}));
        this.install(new FactoryModuleBuilder().implement((TypeLiteral)new TypeLiteral<KafkaConsumerRunnableBasic<AlarmStateTransitionedEvent>>(){}, (TypeLiteral)new TypeLiteral<KafkaConsumerRunnableBasic<AlarmStateTransitionedEvent>>(){}).build((TypeLiteral)new TypeLiteral<KafkaConsumerRunnableBasicFactory<AlarmStateTransitionedEvent>>(){}));
        this.install(new FactoryModuleBuilder().implement((TypeLiteral)new TypeLiteral<KafkaConsumer<MetricEnvelope[]>>(){}, (TypeLiteral)new TypeLiteral<KafkaConsumer<MetricEnvelope[]>>(){}).build((TypeLiteral)new TypeLiteral<KafkaConsumerFactory<MetricEnvelope[]>>(){}));
        this.install(new FactoryModuleBuilder().implement((TypeLiteral)new TypeLiteral<ManagedPipeline<MetricEnvelope[]>>(){}, (TypeLiteral)new TypeLiteral<ManagedPipeline<MetricEnvelope[]>>(){}).build((TypeLiteral)new TypeLiteral<ManagedPipelineFactory<MetricEnvelope[]>>(){}));
        this.install(new FactoryModuleBuilder().implement((TypeLiteral)new TypeLiteral<ManagedPipeline<AlarmStateTransitionedEvent>>(){}, (TypeLiteral)new TypeLiteral<ManagedPipeline<AlarmStateTransitionedEvent>>(){}).build((TypeLiteral)new TypeLiteral<ManagedPipelineFactory<AlarmStateTransitionedEvent>>(){}));
        this.install(new FactoryModuleBuilder().implement((TypeLiteral)new TypeLiteral<ManagedConsumer<AlarmStateTransitionedEvent>>(){}, (TypeLiteral)new TypeLiteral<ManagedConsumer<AlarmStateTransitionedEvent>>(){}).build((TypeLiteral)new TypeLiteral<ManagedConsumerFactory<AlarmStateTransitionedEvent>>(){}));
        this.install(new FactoryModuleBuilder().implement((TypeLiteral)new TypeLiteral<KafkaConsumer<AlarmStateTransitionedEvent>>(){}, (TypeLiteral)new TypeLiteral<KafkaConsumer<AlarmStateTransitionedEvent>>(){}).build((TypeLiteral)new TypeLiteral<KafkaConsumerFactory<AlarmStateTransitionedEvent>>(){}));
        this.install(new FactoryModuleBuilder().implement((TypeLiteral)new TypeLiteral<ManagedConsumer<MetricEnvelope[]>>(){}, (TypeLiteral)new TypeLiteral<ManagedConsumer<MetricEnvelope[]>>(){}).build((TypeLiteral)new TypeLiteral<ManagedConsumerFactory<MetricEnvelope[]>>(){}));
        this.install(new FactoryModuleBuilder().implement(KafkaChannel.class, KafkaChannel.class).build(KafkaChannelFactory.class));
        if (this.config.getDatabaseConfiguration().getDatabaseType().equalsIgnoreCase(VERTICA)) {
            this.bind(DBI.class).toProvider(DBIProvider.class).in(Scopes.SINGLETON);
            this.bind((TypeLiteral)new TypeLiteral<Repo<MetricEnvelope>>(){}).to(VerticaMetricRepo.class);
            this.bind((TypeLiteral)new TypeLiteral<Repo<AlarmStateTransitionedEvent>>(){}).to(VerticaAlarmRepo.class);
        } else if (this.config.getDatabaseConfiguration().getDatabaseType().equalsIgnoreCase(INFLUXDB)) {
            if (this.config.getInfluxDBConfiguration().getVersion() != null && !this.config.getInfluxDBConfiguration().getVersion().equalsIgnoreCase(INFLUXDB_V9)) {
                System.err.println("Found unsupported Influxdb version: " + this.config.getInfluxDBConfiguration().getVersion());
                System.err.println("Supported Influxdb versions are 'v9'");
                System.err.println("Check your config file");
                System.exit(1);
            }
            this.bind(InfluxV9RepoWriter.class).in(Singleton.class);
            this.bind((TypeLiteral)new TypeLiteral<Repo<MetricEnvelope>>(){}).to(InfluxV9MetricRepo.class);
            this.bind((TypeLiteral)new TypeLiteral<Repo<AlarmStateTransitionedEvent>>(){}).to(InfluxV9AlarmRepo.class);
        } else {
            System.err.println("Found unknown database type: " + this.config.getDatabaseConfiguration().getDatabaseType());
            System.err.println("Supported databases are 'vertica' and 'influxdb'");
            System.err.println("Check your config file.");
            System.exit(1);
        }
    }
}

