/*
 * Decompiled with CFR 0.152.
 */
package monasca.persister.repository;

import com.codahale.metrics.Meter;
import com.codahale.metrics.Timer;
import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import io.dropwizard.setup.Environment;
import java.security.NoSuchAlgorithmException;
import java.sql.SQLException;
import java.util.HashSet;
import java.util.Set;
import javax.inject.Inject;
import monasca.persister.configuration.MonPersisterConfiguration;
import monasca.persister.repository.MetricRepository;
import monasca.persister.repository.Sha1HashId;
import monasca.persister.repository.VerticaRepository;
import org.skife.jdbi.v2.DBI;
import org.skife.jdbi.v2.PreparedBatch;
import org.skife.jdbi.v2.PreparedBatchPart;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class VerticaMetricRepository
extends VerticaRepository
implements MetricRepository {
    private static final Logger logger = LoggerFactory.getLogger(VerticaMetricRepository.class);
    private final Environment environment;
    private final Cache<Sha1HashId, Sha1HashId> definitionsIdCache;
    private final Cache<Sha1HashId, Sha1HashId> dimensionsIdCache;
    private final Cache<Sha1HashId, Sha1HashId> definitionDimensionsIdCache;
    private final Set<Sha1HashId> definitionIdSet = new HashSet<Sha1HashId>();
    private final Set<Sha1HashId> dimensionIdSet = new HashSet<Sha1HashId>();
    private final Set<Sha1HashId> definitionDimensionsIdSet = new HashSet<Sha1HashId>();
    private static final String SQL_INSERT_INTO_METRICS = "insert into MonMetrics.measurements (definition_dimensions_id, time_stamp, value) values (:definition_dimension_id, :time_stamp, :value)";
    private static final String DEFINITIONS_TEMP_STAGING_TABLE = "(   id BINARY(20) NOT NULL,   name VARCHAR(255) NOT NULL,   tenant_id VARCHAR(255) NOT NULL,   region VARCHAR(255) NOT NULL)";
    private static final String DIMENSIONS_TEMP_STAGING_TABLE = "(    dimension_set_id BINARY(20) NOT NULL,    name VARCHAR(255) NOT NULL,    value VARCHAR(255) NOT NULL)";
    private static final String DEFINITIONS_DIMENSIONS_TEMP_STAGING_TABLE = "(   id BINARY(20) NOT NULL,   definition_id BINARY(20) NOT NULL,    dimension_set_id BINARY(20) NOT NULL )";
    private PreparedBatch metricsBatch;
    private PreparedBatch stagedDefinitionsBatch;
    private PreparedBatch stagedDimensionsBatch;
    private PreparedBatch stagedDefinitionDimensionsBatch;
    private final String definitionsTempStagingTableName;
    private final String dimensionsTempStagingTableName;
    private final String definitionDimensionsTempStagingTableName;
    private final String definitionsTempStagingTableInsertStmt;
    private final String dimensionsTempStagingTableInsertStmt;
    private final String definitionDimensionsTempStagingTableInsertStmt;
    private final Timer flushTimer;
    public final Meter measurementMeter;
    public final Meter definitionCacheMissMeter;
    public final Meter dimensionCacheMissMeter;
    public final Meter definitionDimensionCacheMissMeter;
    public final Meter definitionCacheHitMeter;
    public final Meter dimensionCacheHitMeter;
    public final Meter definitionDimensionCacheHitMeter;

    @Inject
    public VerticaMetricRepository(DBI dbi, MonPersisterConfiguration configuration, Environment environment) throws NoSuchAlgorithmException, SQLException {
        super(dbi);
        logger.debug("Instantiating: " + this.getClass().getName());
        this.environment = environment;
        this.flushTimer = this.environment.metrics().timer(this.getClass().getName() + "." + "flush-timer");
        this.measurementMeter = this.environment.metrics().meter(this.getClass().getName() + "." + "measurement-meter");
        this.definitionCacheMissMeter = this.environment.metrics().meter(this.getClass().getName() + "." + "definition-cache-miss-meter");
        this.dimensionCacheMissMeter = this.environment.metrics().meter(this.getClass().getName() + "." + "dimension-cache-miss-meter");
        this.definitionDimensionCacheMissMeter = this.environment.metrics().meter(this.getClass().getName() + "." + "definition-dimension-cache-miss-meter");
        this.definitionCacheHitMeter = this.environment.metrics().meter(this.getClass().getName() + "." + "definition-cache-hit-meter");
        this.dimensionCacheHitMeter = this.environment.metrics().meter(this.getClass().getName() + "." + "dimension-cache-hit-meter");
        this.definitionDimensionCacheHitMeter = this.environment.metrics().meter(this.getClass().getName() + "." + "definition-dimension-cache-hit-meter");
        this.definitionsIdCache = CacheBuilder.newBuilder().maximumSize((long)configuration.getVerticaMetricRepositoryConfiguration().getMaxCacheSize().intValue()).build();
        this.dimensionsIdCache = CacheBuilder.newBuilder().maximumSize((long)configuration.getVerticaMetricRepositoryConfiguration().getMaxCacheSize().intValue()).build();
        this.definitionDimensionsIdCache = CacheBuilder.newBuilder().maximumSize((long)configuration.getVerticaMetricRepositoryConfiguration().getMaxCacheSize().intValue()).build();
        logger.info("preparing database and building sql statements...");
        String uniqueName = this.toString().replaceAll("\\.", "_").replaceAll("\\@", "_");
        this.definitionsTempStagingTableName = uniqueName + "_staged_definitions";
        logger.debug("temp staging definitions table name: " + this.definitionsTempStagingTableName);
        this.dimensionsTempStagingTableName = uniqueName + "_staged_dimensions";
        logger.debug("temp staging dimensions table name:" + this.dimensionsTempStagingTableName);
        this.definitionDimensionsTempStagingTableName = uniqueName + "_staged_definitions_dimensions";
        logger.debug("temp staging definitionDimensions table name: " + this.definitionDimensionsTempStagingTableName);
        this.definitionsTempStagingTableInsertStmt = "insert into  MonMetrics.Definitions select distinct * from " + this.definitionsTempStagingTableName + " where id not in (select id from MonMetrics.Definitions)";
        logger.debug("definitions insert stmt: " + this.definitionsTempStagingTableInsertStmt);
        this.dimensionsTempStagingTableInsertStmt = "insert into MonMetrics.Dimensions select distinct * from " + this.dimensionsTempStagingTableName + " where dimension_set_id not in (select dimension_set_id from MonMetrics.Dimensions)";
        logger.debug("dimensions insert stmt: " + this.definitionsTempStagingTableInsertStmt);
        this.definitionDimensionsTempStagingTableInsertStmt = "insert into MonMetrics.definitionDimensions select distinct * from " + this.definitionDimensionsTempStagingTableName + " where id not in (select id from MonMetrics.definitionDimensions)";
        logger.debug("definitionDimensions insert stmt: " + this.definitionDimensionsTempStagingTableInsertStmt);
        logger.debug("dropping temp staging tables if they already exist...");
        this.handle.execute("drop table if exists " + this.definitionsTempStagingTableName + " cascade", new Object[0]);
        this.handle.execute("drop table if exists " + this.dimensionsTempStagingTableName + " cascade", new Object[0]);
        this.handle.execute("drop table if exists " + this.definitionDimensionsTempStagingTableName + " cascade", new Object[0]);
        logger.debug("creating temp staging tables...");
        this.handle.execute("create local temp table " + this.definitionsTempStagingTableName + " " + DEFINITIONS_TEMP_STAGING_TABLE + " on commit preserve rows", new Object[0]);
        this.handle.execute("create local temp table " + this.dimensionsTempStagingTableName + " " + DIMENSIONS_TEMP_STAGING_TABLE + " on commit preserve rows", new Object[0]);
        this.handle.execute("create local temp table " + this.definitionDimensionsTempStagingTableName + " " + DEFINITIONS_DIMENSIONS_TEMP_STAGING_TABLE + " on commit preserve rows", new Object[0]);
        this.handle.getConnection().setAutoCommit(false);
        logger.debug("preparing batches...");
        this.metricsBatch = this.handle.prepareBatch(SQL_INSERT_INTO_METRICS);
        this.stagedDefinitionsBatch = this.handle.prepareBatch("insert into " + this.definitionsTempStagingTableName + " values (:id, :name, :tenant_id, :region)");
        this.stagedDimensionsBatch = this.handle.prepareBatch("insert into " + this.dimensionsTempStagingTableName + " values (:dimension_set_id, :name, :value)");
        this.stagedDefinitionDimensionsBatch = this.handle.prepareBatch("insert into " + this.definitionDimensionsTempStagingTableName + " values (:id, :definition_id, :dimension_set_id)");
        logger.debug("opening transaction...");
        this.handle.begin();
        logger.debug("completed database preparations");
        logger.debug(this.getClass().getName() + "is fully instantiated");
    }

    @Override
    public void addMetricToBatch(Sha1HashId defDimsId, String timeStamp, double value) {
        logger.debug("Adding metric to batch: defDimsId: {}, time: {}, value: {}", new Object[]{defDimsId.toHexString(), timeStamp, value});
        ((PreparedBatchPart)((PreparedBatchPart)this.metricsBatch.add().bind("definition_dimension_id", defDimsId.getSha1Hash())).bind("time_stamp", timeStamp)).bind("value", value);
        this.measurementMeter.mark();
    }

    @Override
    public void addDefinitionToBatch(Sha1HashId defId, String name, String tenantId, String region) {
        if (this.definitionsIdCache.getIfPresent((Object)defId) == null) {
            logger.debug("Adding definition to batch: defId: {}, name: {}, tenantId: {}, region: {}", new Object[]{defId.toHexString(), name, tenantId, region});
            ((PreparedBatchPart)((PreparedBatchPart)((PreparedBatchPart)this.stagedDefinitionsBatch.add().bind("id", defId.getSha1Hash())).bind("name", name)).bind("tenant_id", tenantId)).bind("region", region);
            this.definitionIdSet.add(defId);
            this.definitionCacheMissMeter.mark();
        } else {
            this.definitionCacheHitMeter.mark();
        }
    }

    @Override
    public void addDimensionToBatch(Sha1HashId dimSetId, String name, String value) {
        if (this.dimensionsIdCache.getIfPresent((Object)dimSetId) == null) {
            logger.debug("Adding dimension to batch: dimSetId: {}, name: {}, value: {}", new Object[]{dimSetId.toHexString(), name, value});
            ((PreparedBatchPart)((PreparedBatchPart)this.stagedDimensionsBatch.add().bind("dimension_set_id", dimSetId.getSha1Hash())).bind("name", name)).bind("value", value);
            this.dimensionIdSet.add(dimSetId);
            this.dimensionCacheMissMeter.mark();
        } else {
            this.dimensionCacheHitMeter.mark();
        }
    }

    @Override
    public void addDefinitionDimensionToBatch(Sha1HashId defDimsId, Sha1HashId defId, Sha1HashId dimId) {
        if (this.definitionDimensionsIdCache.getIfPresent((Object)defDimsId) == null) {
            logger.debug("Adding definitionDimension to batch: defDimsId: {}, defId: {}, dimId: {}", new Object[]{defDimsId.toHexString(), defId, dimId});
            ((PreparedBatchPart)((PreparedBatchPart)this.stagedDefinitionDimensionsBatch.add().bind("id", defDimsId.getSha1Hash())).bind("definition_id", defId.getSha1Hash())).bind("dimension_set_id", dimId.getSha1Hash());
            this.definitionDimensionsIdSet.add(defDimsId);
            this.definitionDimensionCacheMissMeter.mark();
        } else {
            this.definitionDimensionCacheHitMeter.mark();
        }
    }

    @Override
    public void flush() {
        try {
            long startTime = System.currentTimeMillis();
            Timer.Context context = this.flushTimer.time();
            this.executeBatches();
            this.writeRowsFromTempStagingTablesToPermTables();
            this.handle.commit();
            this.handle.begin();
            long endTime = System.currentTimeMillis();
            context.stop();
            logger.debug("Writing measurements, definitions, and dimensions to database took " + (endTime - startTime) / 1000L + " seconds");
            this.updateIdCaches();
        }
        catch (Exception e) {
            logger.error("Failed to write measurements, definitions, or dimensions to database", (Throwable)e);
            if (this.handle.isInTransaction()) {
                this.handle.rollback();
            }
            this.clearTempCaches();
            this.handle.begin();
        }
    }

    private void executeBatches() {
        this.metricsBatch.execute();
        this.stagedDefinitionsBatch.execute();
        this.stagedDimensionsBatch.execute();
        this.stagedDefinitionDimensionsBatch.execute();
    }

    private void updateIdCaches() {
        for (Sha1HashId defId : this.definitionIdSet) {
            this.definitionsIdCache.put((Object)defId, (Object)defId);
        }
        for (Sha1HashId dimId : this.dimensionIdSet) {
            this.dimensionsIdCache.put((Object)dimId, (Object)dimId);
        }
        for (Sha1HashId defDimsId : this.definitionDimensionsIdSet) {
            this.definitionDimensionsIdCache.put((Object)defDimsId, (Object)defDimsId);
        }
        this.clearTempCaches();
    }

    private void writeRowsFromTempStagingTablesToPermTables() {
        this.handle.execute(this.definitionsTempStagingTableInsertStmt, new Object[0]);
        this.handle.execute("truncate table " + this.definitionsTempStagingTableName, new Object[0]);
        this.handle.execute(this.dimensionsTempStagingTableInsertStmt, new Object[0]);
        this.handle.execute("truncate table " + this.dimensionsTempStagingTableName, new Object[0]);
        this.handle.execute(this.definitionDimensionsTempStagingTableInsertStmt, new Object[0]);
        this.handle.execute("truncate table " + this.definitionDimensionsTempStagingTableName, new Object[0]);
    }

    private void clearTempCaches() {
        this.definitionIdSet.clear();
        this.dimensionIdSet.clear();
        this.definitionDimensionsIdSet.clear();
    }
}

