/*
 * Decompiled with CFR 0.152.
 */
package monasca.persister.repository;

import io.dropwizard.setup.Environment;
import java.util.List;
import java.util.Map;
import monasca.persister.configuration.MonPersisterConfiguration;
import org.influxdb.InfluxDB;
import org.influxdb.InfluxDBFactory;
import org.influxdb.dto.Serie;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class InfluxRepository {
    static final Logger logger = LoggerFactory.getLogger(InfluxRepository.class);
    protected final MonPersisterConfiguration configuration;
    protected final Environment environment;
    protected final InfluxDB influxDB;

    public InfluxRepository(MonPersisterConfiguration configuration, Environment environment) {
        this.configuration = configuration;
        this.environment = environment;
        this.influxDB = InfluxDBFactory.connect((String)configuration.getInfluxDBConfiguration().getUrl(), (String)configuration.getInfluxDBConfiguration().getUser(), (String)configuration.getInfluxDBConfiguration().getPassword());
    }

    protected void logColValues(Serie serie) {
        logger.debug("Added array of array of column values to serie");
        String[] colNames = serie.getColumns();
        List rows = serie.getRows();
        int outerIdx = 0;
        for (Map row : rows) {
            StringBuffer sb = new StringBuffer();
            boolean first = true;
            for (String colName : colNames) {
                if (first) {
                    first = false;
                } else {
                    sb.append(",");
                }
                sb.append(row.get(colName));
            }
            logger.debug("Array of column values[{}]: [{}]", (Object)outerIdx, (Object)sb);
            ++outerIdx;
        }
    }

    protected void logColumnNames(String[] colNames) {
        logger.debug("Added array of column names to serie");
        StringBuffer sb = new StringBuffer();
        boolean first = true;
        for (String colName : colNames) {
            if (first) {
                first = false;
            } else {
                sb.append(",");
            }
            sb.append(colName);
        }
        logger.debug("Array of column names: [{}]", (Object)sb);
    }
}

