/*
 * Decompiled with CFR 0.152.
 */
package monasca.persister.pipeline.event;

import com.google.inject.Inject;
import com.google.inject.assistedinject.Assisted;
import io.dropwizard.setup.Environment;
import monasca.common.model.event.AlarmStateTransitionedEvent;
import monasca.persister.configuration.PipelineConfiguration;
import monasca.persister.pipeline.event.FlushableHandler;
import monasca.persister.repository.AlarmRepository;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AlarmStateTransitionedEventHandler
extends FlushableHandler<AlarmStateTransitionedEvent> {
    private static final Logger logger = LoggerFactory.getLogger(AlarmStateTransitionedEventHandler.class);
    private final AlarmRepository repository;
    private final int ordinal;

    @Inject
    public AlarmStateTransitionedEventHandler(AlarmRepository repository, @Assisted PipelineConfiguration configuration, Environment environment, @Assisted(value="ordinal") int ordinal, @Assisted(value="batchSize") int batchSize) {
        super(configuration, environment, ordinal, batchSize, AlarmStateTransitionedEventHandler.class.getName());
        this.repository = repository;
        this.ordinal = ordinal;
    }

    @Override
    protected int process(AlarmStateTransitionedEvent event) throws Exception {
        logger.debug("Ordinal:  Event: {}", (Object)this.ordinal, (Object)event);
        this.repository.addToBatch(event);
        return 1;
    }

    @Override
    protected void flushRepository() {
        this.repository.flush();
    }
}

