/*
 * Decompiled with CFR 0.152.
 */
package monasca.persister.pipeline;

import monasca.persister.pipeline.event.FlushableHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ManagedPipeline<T> {
    private static final Logger logger = LoggerFactory.getLogger(ManagedPipeline.class);
    private final FlushableHandler<T> eventHandler;

    public ManagedPipeline(FlushableHandler<T> eventHandler) {
        this.eventHandler = eventHandler;
    }

    public void shutdown() {
        this.eventHandler.flush();
    }

    public boolean publishEvent(T holder) {
        try {
            return this.eventHandler.onEvent(holder);
        }
        catch (Exception e) {
            logger.error("Failed to handle event", (Throwable)e);
            return false;
        }
    }
}

