/*
 * Decompiled with CFR 0.152.
 */
package monasca.persister.consumer;

import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.inject.Inject;
import com.google.inject.assistedinject.Assisted;
import monasca.common.model.metric.MetricEnvelope;
import monasca.persister.consumer.KafkaChannel;
import monasca.persister.consumer.KafkaConsumerRunnableBasic;
import monasca.persister.pipeline.MetricPipeline;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KafkaMetricsConsumerRunnableBasic
extends KafkaConsumerRunnableBasic<MetricEnvelope[]> {
    private static final Logger logger = LoggerFactory.getLogger(KafkaMetricsConsumerRunnableBasic.class);
    private final ObjectMapper objectMapper = new ObjectMapper();

    @Inject
    public KafkaMetricsConsumerRunnableBasic(@Assisted MetricPipeline pipeline, @Assisted KafkaChannel kafkaChannel, @Assisted int threadNumber) {
        super(kafkaChannel, pipeline, threadNumber);
        this.objectMapper.disable(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES);
        this.objectMapper.enable(DeserializationFeature.ACCEPT_SINGLE_VALUE_AS_ARRAY);
    }

    @Override
    protected void publishHeartbeat() {
        this.publishEvent(null);
    }

    @Override
    protected void handleMessage(String message) {
        try {
            MetricEnvelope[] envelopes;
            for (MetricEnvelope envelope : envelopes = (MetricEnvelope[])this.objectMapper.readValue(message, MetricEnvelope[].class)) {
                logger.debug("{}", (Object)envelope);
            }
            this.publishEvent(envelopes);
        }
        catch (Exception e) {
            logger.error("Failed to deserialize JSON message and place on pipeline queue: " + message, (Throwable)e);
        }
    }
}

