/*
 * Decompiled with CFR 0.152.
 */
package monasca.persister.consumer;

import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.inject.Inject;
import com.google.inject.assistedinject.Assisted;
import monasca.common.model.event.AlarmStateTransitionedEvent;
import monasca.persister.consumer.KafkaChannel;
import monasca.persister.consumer.KafkaConsumerRunnableBasic;
import monasca.persister.pipeline.AlarmStateTransitionPipeline;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KafkaAlarmStateTransitionConsumerRunnableBasic
extends KafkaConsumerRunnableBasic<AlarmStateTransitionedEvent> {
    private static final Logger logger = LoggerFactory.getLogger(KafkaAlarmStateTransitionConsumerRunnableBasic.class);
    private final ObjectMapper objectMapper = new ObjectMapper();

    @Inject
    public KafkaAlarmStateTransitionConsumerRunnableBasic(@Assisted AlarmStateTransitionPipeline pipeline, @Assisted KafkaChannel kafkaChannel, @Assisted int threadNumber) {
        super(kafkaChannel, pipeline, threadNumber);
        this.objectMapper.disable(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES);
        this.objectMapper.enable(DeserializationFeature.ACCEPT_SINGLE_VALUE_AS_ARRAY);
        this.objectMapper.enable(DeserializationFeature.UNWRAP_ROOT_VALUE);
    }

    @Override
    protected void publishHeartbeat() {
        this.publishEvent(null);
    }

    @Override
    protected void handleMessage(String message) {
        try {
            AlarmStateTransitionedEvent event = (AlarmStateTransitionedEvent)this.objectMapper.readValue(message, AlarmStateTransitionedEvent.class);
            logger.debug(event.toString());
            this.publishEvent(event);
        }
        catch (Exception e) {
            logger.error("Failed to deserialize JSON message and send to handler: " + message, (Throwable)e);
        }
    }
}

