/*
 * Decompiled with CFR 0.152.
 */
package monasca.persister;

import com.codahale.metrics.health.HealthCheck;
import com.google.inject.Guice;
import com.google.inject.Injector;
import com.google.inject.Module;
import io.dropwizard.Application;
import io.dropwizard.lifecycle.Managed;
import io.dropwizard.setup.Bootstrap;
import io.dropwizard.setup.Environment;
import monasca.persister.MonPersisterModule;
import monasca.persister.configuration.MonPersisterConfiguration;
import monasca.persister.consumer.AlarmStateTransitionConsumer;
import monasca.persister.consumer.AlarmStateTransitionConsumerFactory;
import monasca.persister.consumer.KafkaAlarmStateTransitionConsumer;
import monasca.persister.consumer.KafkaAlarmStateTransitionConsumerFactory;
import monasca.persister.consumer.KafkaChannel;
import monasca.persister.consumer.KafkaChannelFactory;
import monasca.persister.consumer.KafkaMetricsConsumer;
import monasca.persister.consumer.KafkaMetricsConsumerFactory;
import monasca.persister.consumer.MetricsConsumer;
import monasca.persister.consumer.MetricsConsumerFactory;
import monasca.persister.healthcheck.SimpleHealthCheck;
import monasca.persister.pipeline.AlarmStateTransitionPipeline;
import monasca.persister.pipeline.AlarmStateTransitionPipelineFactory;
import monasca.persister.pipeline.MetricPipeline;
import monasca.persister.pipeline.MetricPipelineFactory;
import monasca.persister.pipeline.event.AlarmStateTransitionedEventHandlerFactory;
import monasca.persister.pipeline.event.MetricHandlerFactory;
import monasca.persister.resource.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MonPersisterApplication
extends Application<MonPersisterConfiguration> {
    private static final Logger logger = LoggerFactory.getLogger(MonPersisterApplication.class);

    public static void main(String[] args) throws Exception {
        new MonPersisterApplication().run(args);
    }

    public void initialize(Bootstrap<MonPersisterConfiguration> bootstrap) {
    }

    public String getName() {
        return "monasca-persister";
    }

    public void run(MonPersisterConfiguration configuration, Environment environment) throws Exception {
        Injector injector = Guice.createInjector((Module[])new Module[]{new MonPersisterModule(configuration, environment)});
        environment.jersey().register((Object)new Resource());
        environment.healthChecks().register("test-health-check", (HealthCheck)new SimpleHealthCheck());
        KafkaChannelFactory kafkaChannelFactory = (KafkaChannelFactory)injector.getInstance(KafkaChannelFactory.class);
        MetricsConsumerFactory metricsConsumerFactory = (MetricsConsumerFactory)injector.getInstance(MetricsConsumerFactory.class);
        KafkaMetricsConsumerFactory kafkaMetricsConsumerFactory = (KafkaMetricsConsumerFactory)injector.getInstance(KafkaMetricsConsumerFactory.class);
        for (int i = 0; i < configuration.getMetricConfiguration().getNumThreads(); ++i) {
            KafkaChannel kafkaChannel = kafkaChannelFactory.create(configuration, configuration.getMetricConfiguration(), i);
            MetricPipeline metricPipeline = this.getMetricPipeline(configuration, i, injector);
            KafkaMetricsConsumer kafkaMetricsConsumer = kafkaMetricsConsumerFactory.create(kafkaChannel, i, metricPipeline);
            MetricsConsumer metricsConsumer = metricsConsumerFactory.create(kafkaMetricsConsumer, metricPipeline);
            environment.lifecycle().manage((Managed)metricsConsumer);
        }
        AlarmStateTransitionConsumerFactory alarmStateTransitionsConsumerFactory = (AlarmStateTransitionConsumerFactory)injector.getInstance(AlarmStateTransitionConsumerFactory.class);
        KafkaAlarmStateTransitionConsumerFactory kafkaAlarmStateTransitionConsumerFactory = (KafkaAlarmStateTransitionConsumerFactory)injector.getInstance(KafkaAlarmStateTransitionConsumerFactory.class);
        for (int i = 0; i < configuration.getAlarmHistoryConfiguration().getNumThreads(); ++i) {
            KafkaChannel kafkaChannel = kafkaChannelFactory.create(configuration, configuration.getAlarmHistoryConfiguration(), i);
            AlarmStateTransitionPipeline pipeline = this.getAlarmStateHistoryPipeline(configuration, i, injector);
            KafkaAlarmStateTransitionConsumer kafkaAlarmStateTransitionConsumer = kafkaAlarmStateTransitionConsumerFactory.create(kafkaChannel, i, pipeline);
            AlarmStateTransitionConsumer alarmStateTransitionConsumer = alarmStateTransitionsConsumerFactory.create(kafkaAlarmStateTransitionConsumer, pipeline);
            environment.lifecycle().manage((Managed)alarmStateTransitionConsumer);
        }
    }

    private MetricPipeline getMetricPipeline(MonPersisterConfiguration configuration, int threadNum, Injector injector) {
        logger.debug("Creating metric pipeline...");
        int batchSize = configuration.getMetricConfiguration().getBatchSize();
        logger.debug("Batch size for metric pipeline [" + batchSize + "]");
        MetricHandlerFactory metricEventHandlerFactory = (MetricHandlerFactory)injector.getInstance(MetricHandlerFactory.class);
        MetricPipelineFactory metricPipelineFactory = (MetricPipelineFactory)injector.getInstance(MetricPipelineFactory.class);
        MetricPipeline pipeline = metricPipelineFactory.create(metricEventHandlerFactory.create(configuration.getMetricConfiguration(), threadNum, batchSize));
        logger.debug("Instance of metric pipeline fully created");
        return pipeline;
    }

    public AlarmStateTransitionPipeline getAlarmStateHistoryPipeline(MonPersisterConfiguration configuration, int threadNum, Injector injector) {
        logger.debug("Creating alarm state history pipeline...");
        int batchSize = configuration.getAlarmHistoryConfiguration().getBatchSize();
        logger.debug("Batch size for each AlarmStateHistoryPipeline [" + batchSize + "]");
        AlarmStateTransitionedEventHandlerFactory alarmHistoryEventHandlerFactory = (AlarmStateTransitionedEventHandlerFactory)injector.getInstance(AlarmStateTransitionedEventHandlerFactory.class);
        AlarmStateTransitionPipelineFactory alarmStateTransitionPipelineFactory = (AlarmStateTransitionPipelineFactory)injector.getInstance(AlarmStateTransitionPipelineFactory.class);
        AlarmStateTransitionPipeline pipeline = alarmStateTransitionPipelineFactory.create(alarmHistoryEventHandlerFactory.create(configuration.getAlarmHistoryConfiguration(), threadNum, batchSize));
        logger.debug("Instance of alarm state history pipeline fully created");
        return pipeline;
    }
}

