/*
 * Decompiled with CFR 0.152.
 */
package monasca.log.api.resource.exception;

import io.dropwizard.jersey.validation.ValidationErrorMessage;
import javax.validation.ConstraintViolationException;
import javax.ws.rs.core.Response;
import javax.ws.rs.ext.ExceptionMapper;
import javax.ws.rs.ext.Provider;
import monasca.log.api.resource.exception.Exceptions;

@Provider
public class ConstraintViolationExceptionMapper
implements ExceptionMapper<ConstraintViolationException> {
    private static final int UNPROCESSABLE_ENTITY = 422;

    public Response toResponse(ConstraintViolationException exception) {
        ValidationErrorMessage message = new ValidationErrorMessage(exception.getConstraintViolations());
        String msg = message.getErrors().isEmpty() ? exception.getMessage() : message.getErrors().toString();
        return Response.status((int)422).type("application/json").entity((Object)Exceptions.buildLoggedErrorMessage(Exceptions.FaultType.UNPROCESSABLE_ENTITY, msg, new Object[0])).build();
    }
}

