/*
 * Decompiled with CFR 0.152.
 */
package monasca.log.api.resource;

import com.codahale.metrics.annotation.Timed;
import com.google.common.base.Splitter;
import com.google.common.base.Strings;
import com.sun.jersey.api.core.HttpRequestContext;
import java.util.Map;
import javax.inject.Inject;
import javax.ws.rs.Consumes;
import javax.ws.rs.HeaderParam;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Request;
import monasca.log.api.app.LogService;
import monasca.log.api.app.validation.Validation;
import monasca.log.api.common.LogRequestBean;
import monasca.log.api.model.Log;
import monasca.log.api.resource.exception.Exceptions;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Path(value="/v2.0/log")
public class LogResource {
    private static final Logger LOGGER = LoggerFactory.getLogger(LogResource.class);
    private static final String MONITORING_DELEGATE_ROLE = "monitoring-delegate";
    private static final Splitter COMMA_SPLITTER = Splitter.on((char)',').omitEmptyStrings().trimResults();
    private static final boolean VALIDATE_LOG = true;
    private final LogService service;

    @Inject
    public LogResource(LogService service) {
        this.service = service;
    }

    @POST
    @Timed
    @Consumes(value={"application/json"})
    @Path(value="/single")
    public void single(@Context Request request, @HeaderParam(value="X-Tenant-Id") String tenantId, @HeaderParam(value="X-Roles") String roles, @HeaderParam(value="X-Application-Type") String applicationType, @HeaderParam(value="X-Dimensions") String dimensionsStr, @QueryParam(value="tenant_id") String crossTenantId, String payload) {
        LOGGER.debug("/single/{}", (Object)tenantId);
        MediaType contentType = this.getContentType(request);
        this.service.validateContentLength(this.getContentLength(request));
        this.service.validateContentType(contentType);
        if (!this.isDelegate(roles)) {
            LOGGER.trace(String.format("/single/%s is not delegated request, checking for crossTenantId", tenantId));
            if (!Strings.isNullOrEmpty((String)crossTenantId)) {
                throw Exceptions.forbidden("Project %s cannot POST cross tenant metrics", tenantId);
            }
        }
        Log log = this.service.newLog(new LogRequestBean().setApplicationType(applicationType).setDimensions(this.getDimensions(dimensionsStr)).setContentType(contentType).setPayload(payload), true);
        tenantId = this.getTenantId(tenantId, crossTenantId);
        LOGGER.debug("Shipping log={},tenantId={} pair to kafka", (Object)log, (Object)tenantId);
        this.service.sendToKafka(log, tenantId);
    }

    private MediaType getContentType(Request request) {
        return ((HttpRequestContext)request).getMediaType();
    }

    private Integer getContentLength(Request request) {
        String value = ((HttpRequestContext)request).getHeaderValue("Content-Length");
        return StringUtils.isNotEmpty((CharSequence)value) ? Integer.valueOf(value) : null;
    }

    private String getTenantId(String tenantId, String crossTenantId) {
        return Strings.isNullOrEmpty((String)crossTenantId) ? tenantId : crossTenantId;
    }

    private Map<String, String> getDimensions(String dimensionsStr) {
        return Strings.isNullOrEmpty((String)dimensionsStr) ? null : Validation.parseLogDimensions(dimensionsStr);
    }

    private boolean isDelegate(String roles) {
        return !Strings.isNullOrEmpty((String)roles) && COMMA_SPLITTER.splitToList((CharSequence)roles).contains(MONITORING_DELEGATE_ROLE);
    }
}

