/*
 * Decompiled with CFR 0.152.
 */
package monasca.log.api.infrastructure.servlet;

import com.sun.jersey.spi.container.ContainerRequest;
import com.sun.jersey.spi.container.ContainerRequestFilter;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.core.Context;
import monasca.log.api.resource.exception.Exceptions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RoleAuthorizationFilter
implements ContainerRequestFilter {
    private static final Logger logger = LoggerFactory.getLogger(ContainerRequestFilter.class);
    @Context
    private HttpServletRequest httpServletRequest;
    private static final String[] VALID_MONASCA_AGENT_POST_PATHS = new String[]{"/v2.0/metrics", "/v2.0/log/single"};
    private static final String[] VALID_MONASCA_AGENT_GET_PATHS = new String[]{"/", "/v2.0"};

    public ContainerRequest filter(ContainerRequest containerRequest) {
        String method = containerRequest.getMethod();
        Object isAgent = this.httpServletRequest.getAttribute("X-MONASCA-LOG-AGENT");
        String pathInfo = this.httpServletRequest.getPathInfo();
        if (!(isAgent == null || method.equals("POST") && this.validPath(pathInfo, VALID_MONASCA_AGENT_POST_PATHS) || method.equals("GET") && this.validPath(pathInfo, VALID_MONASCA_AGENT_GET_PATHS))) {
            logger.warn("User {} is missing a required role to {} on {}", new Object[]{this.httpServletRequest.getAttribute("X-USER-NAME"), method, pathInfo});
            throw Exceptions.badRequest("User is missing a required role to perform this request", new Object[0]);
        }
        return containerRequest;
    }

    private boolean validPath(String pathInfo, String[] paths) {
        while (!pathInfo.isEmpty() && !"/".equals(pathInfo) && pathInfo.endsWith("/")) {
            pathInfo = pathInfo.substring(0, pathInfo.length() - 1);
        }
        for (String validPath : paths) {
            if (!validPath.equals(pathInfo)) continue;
            return true;
        }
        return false;
    }
}

