/*
 * Decompiled with CFR 0.152.
 */
package monasca.log.api.infrastructure.servlet;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.List;
import javax.annotation.Nullable;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletRequestWrapper;
import monasca.log.api.infrastructure.servlet.PreAuthenticationFilter;

public class PostAuthenticationFilter
implements Filter {
    static final String CONFIRMED_STATUS = "CONFIRMED";
    static final String X_ROLES_ATTRIBUTE = "X-ROLES";
    static final String X_MONASCA_LOG_AGENT = "X-MONASCA-LOG-AGENT";
    static final String X_IDENTITY_STATUS_ATTRIBUTE = "X-IDENTITY-STATUS";
    private static final String X_TENANT_ID_ATTRIBUTE = "X-PROJECT-ID";
    static final String X_TENANT_ID_HEADER = "X-Tenant-Id";
    static final String X_ROLES_HEADER = "X-Roles";
    private final List<String> defaultAuthorizedRoles = new ArrayList<String>();
    private final List<String> agentAuthorizedRoles = new ArrayList<String>();

    public PostAuthenticationFilter(List<String> defaultAuthorizedRoles, List<String> agentAuthorizedRoles) {
        for (String defaultRole : defaultAuthorizedRoles) {
            this.defaultAuthorizedRoles.add(defaultRole.toLowerCase());
        }
        for (String agentRole : agentAuthorizedRoles) {
            this.agentAuthorizedRoles.add(agentRole.toLowerCase());
        }
    }

    public void destroy() {
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) {
        HttpServletRequest req = (HttpServletRequest)request;
        PreAuthenticationFilter.ErrorCapturingServletResponseWrapper res = (PreAuthenticationFilter.ErrorCapturingServletResponseWrapper)response;
        String tenantIdStr = null;
        try {
            if (req.getMethod().equals("OPTIONS")) {
                chain.doFilter(request, response);
                return;
            }
            Object tenantId = request.getAttribute(X_TENANT_ID_ATTRIBUTE);
            if (tenantId == null) {
                this.sendAuthError(res, null, null, null);
                return;
            }
            tenantIdStr = tenantId.toString();
            boolean authenticated = this.isAuthenticated(req);
            boolean authorized = this.isAuthorized(req);
            if (authenticated && authorized) {
                HttpServletRequestWrapper wrapper = this.requestWrapperFor(req);
                chain.doFilter((ServletRequest)wrapper, response);
                return;
            }
            if (authorized) {
                this.sendAuthError(res, tenantIdStr, null, null);
            } else {
                this.sendAuthError(res, tenantIdStr, "Tenant is missing a required role to access this service", null);
            }
        }
        catch (Exception e) {
            try {
                this.sendAuthError(res, tenantIdStr, null, e);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    public void init(FilterConfig filterConfig) throws ServletException {
    }

    private boolean isAuthenticated(HttpServletRequest request) {
        Object identityStatus = request.getAttribute(X_IDENTITY_STATUS_ATTRIBUTE);
        return identityStatus != null && CONFIRMED_STATUS.equalsIgnoreCase(identityStatus.toString());
    }

    private boolean isAuthorized(HttpServletRequest request) {
        Object rolesFromKeystone = request.getAttribute(X_ROLES_ATTRIBUTE);
        if (rolesFromKeystone == null) {
            return false;
        }
        boolean agentUser = false;
        for (String role : rolesFromKeystone.toString().split(",")) {
            String lowerCaseRole = role.toLowerCase();
            if (this.defaultAuthorizedRoles != null && this.defaultAuthorizedRoles.contains(lowerCaseRole)) {
                return true;
            }
            if (this.agentAuthorizedRoles == null || !this.agentAuthorizedRoles.contains(lowerCaseRole)) continue;
            agentUser = true;
        }
        if (agentUser) {
            request.setAttribute(X_MONASCA_LOG_AGENT, (Object)true);
            return true;
        }
        return false;
    }

    private HttpServletRequestWrapper requestWrapperFor(final HttpServletRequest request) {
        return new HttpServletRequestWrapper(request){

            public String getHeader(String name) {
                if (name.equalsIgnoreCase(PostAuthenticationFilter.X_TENANT_ID_HEADER)) {
                    return request.getAttribute(PostAuthenticationFilter.X_TENANT_ID_ATTRIBUTE).toString();
                }
                if (name.equalsIgnoreCase(PostAuthenticationFilter.X_ROLES_HEADER)) {
                    return request.getAttribute(PostAuthenticationFilter.X_ROLES_ATTRIBUTE).toString();
                }
                return super.getHeader(name);
            }

            public Enumeration<String> getHeaderNames() {
                ArrayList names = Collections.list(super.getHeaderNames());
                names.add(PostAuthenticationFilter.X_TENANT_ID_HEADER);
                names.add(PostAuthenticationFilter.X_ROLES_HEADER);
                return Collections.enumeration(names);
            }

            public Enumeration<String> getHeaders(String name) {
                if (name.equalsIgnoreCase(PostAuthenticationFilter.X_TENANT_ID_HEADER)) {
                    return Collections.enumeration(Collections.singleton(request.getAttribute(PostAuthenticationFilter.X_TENANT_ID_ATTRIBUTE).toString()));
                }
                if (name.equalsIgnoreCase(PostAuthenticationFilter.X_ROLES_HEADER)) {
                    return Collections.enumeration(Collections.singleton(request.getAttribute(PostAuthenticationFilter.X_ROLES_ATTRIBUTE).toString()));
                }
                return super.getHeaders(name);
            }
        };
    }

    private void sendAuthError(PreAuthenticationFilter.ErrorCapturingServletResponseWrapper response, @Nullable String tenantId, @Nullable String message, @Nullable Exception exception) throws IOException {
        response.setContentType("application/json");
        if (message == null) {
            response.sendError(401, tenantId == null ? "Failed to authenticate request" : "Failed to authenticate request for " + tenantId, exception);
        } else {
            response.sendError(401, String.format(message, tenantId));
        }
    }
}

