/*
 * Decompiled with CFR 0.152.
 */
package monasca.log.api.infrastructure.servlet;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletRequestWrapper;

public class MockAuthenticationFilter
implements Filter {
    private static final String X_AUTH_TOKEN_HEADER = "X-Auth-Token";

    public void destroy() {
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        HttpServletRequest req = (HttpServletRequest)request;
        HttpServletRequestWrapper wrapper = this.requestWrapperFor(req);
        chain.doFilter((ServletRequest)wrapper, response);
    }

    public void init(FilterConfig filterConfig) throws ServletException {
    }

    private HttpServletRequestWrapper requestWrapperFor(final HttpServletRequest request) {
        return new HttpServletRequestWrapper(request){

            public Object getAttribute(String name) {
                if (name.equalsIgnoreCase("X-Tenant-Id")) {
                    String tenantId = request.getHeader("X-Tenant-Id");
                    return tenantId == null ? request.getHeader(MockAuthenticationFilter.X_AUTH_TOKEN_HEADER) : tenantId;
                }
                if (name.equalsIgnoreCase("X-IDENTITY-STATUS")) {
                    return "CONFIRMED";
                }
                if (name.equalsIgnoreCase("X-ROLES")) {
                    return "user";
                }
                return super.getAttribute(name);
            }

            public String getHeader(String name) {
                if (name.equalsIgnoreCase("X-Tenant-Id")) {
                    return request.getHeader(MockAuthenticationFilter.X_AUTH_TOKEN_HEADER);
                }
                return super.getHeader(name);
            }

            public Enumeration<String> getHeaderNames() {
                ArrayList names = Collections.list(super.getHeaderNames());
                names.add("X-Tenant-Id");
                return Collections.enumeration(names);
            }

            public Enumeration<String> getHeaders(String name) {
                if (name.equalsIgnoreCase("X-Tenant-Id")) {
                    String authToken = request.getHeader(MockAuthenticationFilter.X_AUTH_TOKEN_HEADER);
                    return authToken == null ? Collections.emptyEnumeration() : Collections.enumeration(Collections.singleton(authToken));
                }
                return super.getHeaders(name);
            }
        };
    }
}

