/*
 * Decompiled with CFR 0.152.
 */
package monasca.log.api.app.validation;

import com.google.common.base.CharMatcher;
import java.util.regex.Pattern;
import monasca.log.api.resource.exception.Exceptions;

public class LogApplicationTypeValidator {
    private static final Pattern VALID_APPLICATION_TYPE = Pattern.compile("^[a-zA-Z0-9_\\.\\-]+$");

    private LogApplicationTypeValidator() {
    }

    public static String normalize(String applicationType) {
        return applicationType == null ? null : CharMatcher.WHITESPACE.trimFrom((CharSequence)applicationType);
    }

    public static void validate(String applicationType) {
        if (applicationType.length() > 255) {
            throw Exceptions.unprocessableEntity("Application type %s must be %d characters or less", applicationType, 255);
        }
        if (!VALID_APPLICATION_TYPE.matcher(applicationType).matches()) {
            throw Exceptions.unprocessableEntity("Application type %s may only contain: a-z A-Z 0-9 _ - .", applicationType);
        }
    }
}

