/*
 * Decompiled with CFR 0.152.
 */
package monasca.log.api.app.unload;

import com.google.inject.Inject;
import javax.ws.rs.core.MediaType;
import monasca.log.api.app.LogSerializer;
import monasca.log.api.common.PayloadTransformer;
import monasca.log.api.model.Log;
import org.apache.commons.lang3.StringUtils;

public class JsonPayloadTransformer
extends PayloadTransformer {
    private final LogSerializer serializer;

    @Inject
    public JsonPayloadTransformer(LogSerializer serializer) {
        this.serializer = serializer;
    }

    @Override
    public Log transform(String from) {
        if (StringUtils.isEmpty((CharSequence)from)) {
            return new Log().setMessage("");
        }
        return this.serializer.logFromJson(from.getBytes());
    }

    @Override
    public MediaType supportsMediaType() {
        return MediaType.APPLICATION_JSON_TYPE;
    }
}

