/*
 * Decompiled with CFR 0.152.
 */
package monasca.log.api.app;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.inject.Inject;
import monasca.common.util.Exceptions;
import monasca.log.api.model.Log;
import monasca.log.api.model.LogEnvelope;

public class LogSerializer {
    private final ObjectMapper objectMapper;

    @Inject
    public LogSerializer(ObjectMapper objectMapper) {
        this.objectMapper = objectMapper;
    }

    public Log logFromJson(byte[] bytes) {
        return this.fromJson(bytes, Log.class);
    }

    public LogEnvelope logEnvelopeFromJson(byte[] bytes) {
        return this.fromJson(bytes, LogEnvelope.class);
    }

    public String logToJson(Log log) {
        return this.toJson(log);
    }

    public String logEnvelopeToJson(LogEnvelope envelope) {
        return this.toJson(envelope);
    }

    protected <T> T fromJson(byte[] logJson, Class<T> target) {
        try {
            return (T)this.objectMapper.readValue(new String(logJson, "UTF-8"), target);
        }
        catch (Exception e) {
            throw Exceptions.uncheck((Exception)e, (String)"Failed to parse log json: %s", (Object[])new Object[]{new String(logJson)});
        }
    }

    protected <T> String toJson(T log) {
        try {
            return this.objectMapper.writeValueAsString(log);
        }
        catch (JsonProcessingException e) {
            throw Exceptions.uncheck((Exception)((Object)e), (String)"Failed to create log json: %s", (Object[])new Object[]{log});
        }
    }
}

