/*
 * Decompiled with CFR 0.152.
 */
package monasca.log.api.app;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.PropertyNamingStrategy;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.google.inject.AbstractModule;
import com.google.inject.Provides;
import com.google.inject.name.Named;
import java.util.TimeZone;
import javax.inject.Singleton;
import monasca.log.api.app.LogSerializer;
import monasca.log.api.app.LogService;
import monasca.log.api.app.unload.JsonPayloadTransformer;

public class ApplicationModule
extends AbstractModule {
    private static final boolean FAIL_ON_UNKNOWN_PROPERTIES = false;
    private static final boolean ACCEPT_SINGLE_VALUE_AS_ARRAY = true;
    private static final boolean ORDER_MAP_ENTRIES_BY_KEYS = true;
    private static final String TIME_ZONE_UTC = "UTC";

    protected void configure() {
        this.bind(LogSerializer.class).in(Singleton.class);
        this.bind(LogService.class).in(Singleton.class);
        this.bind(JsonPayloadTransformer.class).in(Singleton.class);
    }

    @Named(value="objectMapper")
    @Provides
    public ObjectMapper objectMapper() {
        return new ObjectMapper().setPropertyNamingStrategy(PropertyNamingStrategy.CAMEL_CASE_TO_LOWER_CASE_WITH_UNDERSCORES).configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false).configure(DeserializationFeature.ACCEPT_SINGLE_VALUE_AS_ARRAY, true).configure(SerializationFeature.ORDER_MAP_ENTRIES_BY_KEYS, true).setTimeZone(TimeZone.getTimeZone(TIME_ZONE_UTC)).setSerializationInclusion(JsonInclude.Include.NON_NULL);
    }
}

