/*
 * Decompiled with CFR 0.152.
 */
package monasca.log.api;

import com.google.common.base.Joiner;
import com.google.inject.AbstractModule;
import com.google.inject.Module;
import com.google.inject.Provides;
import java.util.Properties;
import javax.inject.Singleton;
import kafka.javaapi.producer.Producer;
import kafka.producer.ProducerConfig;
import monasca.log.api.ApiConfig;
import monasca.log.api.app.ApplicationModule;

public class MonApiModule
extends AbstractModule {
    private final ApiConfig config;

    public MonApiModule(ApiConfig config) {
        this.config = config;
    }

    protected void configure() {
        this.bind(ApiConfig.class).toInstance((Object)this.config);
        this.install((Module)new ApplicationModule());
    }

    @Provides
    @Singleton
    public Producer<String, String> getProducer() {
        Properties props = new Properties();
        props.put("metadata.broker.list", Joiner.on((char)',').join((Object[])this.config.kafka.brokerUris));
        props.put("serializer.class", "kafka.serializer.StringEncoder");
        props.put("request.required.acks", "1");
        ProducerConfig config = new ProducerConfig(props);
        return new Producer(config);
    }
}

