/*
 * Decompiled with CFR 0.152.
 */
package monasca.api.resource;

import com.codahale.metrics.annotation.Timed;
import java.io.UnsupportedEncodingException;
import javax.inject.Inject;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.UriInfo;
import monasca.api.domain.model.version.Version;
import monasca.api.domain.model.version.VersionRepo;
import monasca.api.infrastructure.persistence.PersistUtils;
import monasca.api.resource.Links;

@Path(value="/")
@Produces(value={"application/json"})
public class VersionResource {
    private final VersionRepo repository;
    private final PersistUtils persistUtils;

    @Inject
    public VersionResource(VersionRepo repository, PersistUtils persistUtils) {
        this.repository = repository;
        this.persistUtils = persistUtils;
    }

    @GET
    @Timed
    public Object list(@Context UriInfo uriInfo, @QueryParam(value="offset") String offset, @QueryParam(value="limit") String limit) throws UnsupportedEncodingException {
        return Links.paginate(this.persistUtils.getLimit(limit), Links.hydrate(this.repository.find(), uriInfo, new String[0]), uriInfo);
    }

    @GET
    @Timed
    @Path(value="{version_id}")
    public Version get(@Context UriInfo uriInfo, @PathParam(value="version_id") String versionId) {
        return Links.hydrate(this.repository.findById(versionId), uriInfo, true, new String[0]);
    }
}

