/*
 * Decompiled with CFR 0.152.
 */
package monasca.api.resource;

import com.codahale.metrics.annotation.Timed;
import com.google.common.base.Splitter;
import com.google.common.base.Strings;
import java.util.List;
import java.util.Map;
import javax.inject.Inject;
import javax.ws.rs.DefaultValue;
import javax.ws.rs.GET;
import javax.ws.rs.HeaderParam;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.UriInfo;
import monasca.api.ApiConfig;
import monasca.api.app.validation.MetricNameValidation;
import monasca.api.app.validation.Validation;
import monasca.api.domain.model.statistic.StatisticRepo;
import monasca.api.infrastructure.persistence.PersistUtils;
import monasca.api.resource.Links;
import org.joda.time.DateTime;

@Path(value="/v2.0/metrics/statistics")
public class StatisticResource {
    private static final Splitter COMMA_SPLITTER = Splitter.on((char)',').omitEmptyStrings().trimResults();
    private final String admin_role;
    private final StatisticRepo repo;
    private final PersistUtils persistUtils;

    @Inject
    public StatisticResource(ApiConfig config, StatisticRepo repo, PersistUtils persistUtils) {
        this.admin_role = config.middleware == null || config.middleware.adminRole == null ? "monasca-admin" : config.middleware.adminRole;
        this.repo = repo;
        this.persistUtils = persistUtils;
    }

    @GET
    @Timed
    @Produces(value={"application/json"})
    public Object get(@Context UriInfo uriInfo, @HeaderParam(value="X-Tenant-Id") String tenantId, @HeaderParam(value="X-Roles") String roles, @QueryParam(value="name") String name, @QueryParam(value="dimensions") String dimensionsStr, @QueryParam(value="start_time") String startTimeStr, @QueryParam(value="end_time") String endTimeStr, @QueryParam(value="statistics") String statisticsStr, @DefaultValue(value="300") @QueryParam(value="period") String periodStr, @QueryParam(value="offset") String offset, @QueryParam(value="limit") String limit, @QueryParam(value="tenant_id") String crossTenantId, @QueryParam(value="merge_metrics") String mergeMetricsFlag, @QueryParam(value="group_by") String groupByStr) throws Exception {
        Validation.validateNotNullOrEmpty(name, "name");
        DateTime startTime = Validation.parseAndValidateDate(startTimeStr, "start_time", true);
        DateTime endTime = Validation.parseAndValidateDate(endTimeStr, "end_time", false);
        Validation.validateTimes(startTime, endTime);
        Validation.validateNotNullOrEmpty(statisticsStr, "statistics");
        int period = Validation.parseAndValidateNumber(periodStr, "period");
        List<String> statistics = Validation.parseValidateAndNormalizeStatistics(COMMA_SPLITTER.split((CharSequence)statisticsStr));
        Map<String, String> dimensions = Strings.isNullOrEmpty((String)dimensionsStr) ? null : Validation.parseAndValidateDimensions(dimensionsStr);
        MetricNameValidation.validate(name, true);
        Boolean mergeMetricsFlagBool = Validation.validateAndParseMergeMetricsFlag(mergeMetricsFlag);
        List<String> groupBy = Validation.parseAndValidateMetricsGroupBy(groupByStr);
        String queryTenantId = Validation.getQueryProject(roles, crossTenantId, tenantId, this.admin_role);
        return Links.paginateMeasurements(this.persistUtils.getLimit(limit), this.repo.find(queryTenantId, name, dimensions, startTime, endTime, statistics, period, offset, this.persistUtils.getLimit(limit), mergeMetricsFlagBool, groupBy), uriInfo);
    }
}

