/*
 * Decompiled with CFR 0.152.
 */
package monasca.api.infrastructure.persistence.mysql;

import com.google.common.base.Joiner;
import com.google.common.base.Splitter;
import com.google.common.base.Strings;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.inject.Inject;
import javax.inject.Named;
import monasca.api.domain.exception.EntityNotFoundException;
import monasca.api.domain.model.alarm.Alarm;
import monasca.api.domain.model.alarm.AlarmCount;
import monasca.api.domain.model.alarm.AlarmRepo;
import monasca.api.infrastructure.persistence.DimensionQueries;
import monasca.api.infrastructure.persistence.PersistUtils;
import monasca.api.infrastructure.persistence.mysql.MySQLUtils;
import monasca.common.model.alarm.AlarmSeverity;
import monasca.common.model.alarm.AlarmState;
import monasca.common.model.alarm.AlarmSubExpression;
import monasca.common.model.metric.MetricDefinition;
import monasca.common.persistence.BeanMapper;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;
import org.skife.jdbi.v2.DBI;
import org.skife.jdbi.v2.Handle;
import org.skife.jdbi.v2.Query;
import org.skife.jdbi.v2.tweak.ResultSetMapper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AlarmMySqlRepoImpl
implements AlarmRepo {
    private static final Joiner COMMA_JOINER = Joiner.on((char)',');
    private static final Splitter SPACE_SPLITTER = Splitter.on((char)' ');
    private static final Logger logger = LoggerFactory.getLogger(AlarmMySqlRepoImpl.class);
    private final DBI db;
    private final PersistUtils persistUtils;
    private static final String FIND_ALARM_BY_ID_SQL = "select ad.id as alarm_definition_id, ad.severity, ad.name as alarm_definition_name, a.id as alarm_id, a.state, a.lifecycle_state, a.link, a.state_updated_at as state_updated_timestamp, a.updated_at as updated_timestamp, a.created_at as created_timestamp, md.name as metric_name, mdg.dimensions as metric_dimensions from alarm as a inner join alarm_definition ad on ad.id = a.alarm_definition_id inner join alarm_metric as am on am.alarm_id = a.id inner join metric_definition_dimensions as mdd on mdd.id = am.metric_definition_dimensions_id inner join metric_definition as md on md.id = mdd.metric_definition_id left outer join (select dimension_set_id, name, value, group_concat(name, '=', value) as dimensions from metric_dimension group by dimension_set_id) as mdg on mdg.dimension_set_id = mdd.metric_dimension_set_id where ad.tenant_id = :tenantId and ad.deleted_at is null %s order by a.id %s";
    private static final String FIND_ALARMS_SQL = "select ad.id as alarm_definition_id, ad.severity, ad.name as alarm_definition_name, a.id as alarm_id, a.state, a.lifecycle_state, a.link, a.state_updated_at as state_updated_timestamp, a.updated_at as updated_timestamp, a.created_at as created_timestamp, md.name as metric_name, group_concat(mdim.name, '=', mdim.value order by mdim.name) as metric_dimensions from alarm as a inner join %1$s as alarm_id_list on alarm_id_list.id = a.id inner join alarm_definition ad on ad.id = a.alarm_definition_id inner join alarm_metric as am on am.alarm_id = a.id inner join metric_definition_dimensions as mdd on mdd.id = am.metric_definition_dimensions_id inner join metric_definition as md on md.id = mdd.metric_definition_id left outer join metric_dimension as mdim on mdim.dimension_set_id = mdd.metric_dimension_set_id group by a.id, md.name, mdim.dimension_set_id %2$s";

    @Inject
    public AlarmMySqlRepoImpl(@Named(value="mysql") DBI db, PersistUtils persistUtils) {
        this.db = db;
        this.persistUtils = persistUtils;
    }

    private void buildJoinClauseFor(Map<String, String> dimensions, StringBuilder sbJoin) {
        if (dimensions == null) {
            return;
        }
        int i = 0;
        for (String dimension_key : dimensions.keySet()) {
            String indexStr = String.valueOf(i);
            sbJoin.append(" inner join metric_dimension md").append(indexStr).append(" on md").append(indexStr).append(".name = :dname").append(indexStr);
            String dim_value = dimensions.get(dimension_key);
            if (!Strings.isNullOrEmpty((String)dim_value)) {
                sbJoin.append(" and (");
                List values = Splitter.on((char)'|').splitToList((CharSequence)dim_value);
                for (int j = 0; j < values.size(); ++j) {
                    sbJoin.append(" md").append(indexStr).append(".value = :dvalue").append(indexStr).append('_').append(j);
                    if (j >= values.size() - 1) continue;
                    sbJoin.append(" or");
                }
                sbJoin.append(")");
            }
            sbJoin.append(" and mdd.metric_dimension_set_id = md").append(indexStr).append(".dimension_set_id");
            ++i;
        }
    }

    @Override
    public void deleteById(String tenantId, String id) {
        String sql = "delete a from alarm a where a.id = ?";
        try (Handle h = this.db.open();){
            this.findAlarm(tenantId, id, h);
            h.execute("delete a from alarm a where a.id = ?", new Object[]{id});
        }
    }

    @Override
    public List<Alarm> find(String tenantId, String alarmDefId, String metricName, Map<String, String> metricDimensions, AlarmState state, List<AlarmSeverity> severities, String lifecycleState, String link, DateTime stateUpdatedStart, List<String> sortBy, String offset, int limit, boolean enforceLimit) {
        StringBuilder sbWhere = new StringBuilder("(select a.id from alarm as a, alarm_definition as ad where ad.id = a.alarm_definition_id   and ad.deleted_at is null   and ad.tenant_id = :tenantId ");
        if (alarmDefId != null) {
            sbWhere.append(" and ad.id = :alarmDefId ");
        }
        if (metricName != null) {
            sbWhere.append(" and a.id in (select distinct a.id from alarm as a inner join alarm_metric as am on am.alarm_id = a.id inner join metric_definition_dimensions as mdd   on mdd.id = am.metric_definition_dimensions_id inner join (select distinct id from metric_definition             where name = :metricName) as md   on md.id = mdd.metric_definition_id ");
            this.buildJoinClauseFor(metricDimensions, sbWhere);
            sbWhere.append(")");
        } else if (metricDimensions != null) {
            sbWhere.append(" and a.id in (select distinct a.id from alarm as a inner join alarm_metric as am on am.alarm_id = a.id inner join metric_definition_dimensions as mdd   on mdd.id = am.metric_definition_dimensions_id ");
            this.buildJoinClauseFor(metricDimensions, sbWhere);
            sbWhere.append(")");
        }
        if (state != null) {
            sbWhere.append(" and a.state = :state");
        }
        sbWhere.append(MySQLUtils.buildSeverityAndClause(severities));
        if (lifecycleState != null) {
            sbWhere.append(" and a.lifecycle_state = :lifecycleState");
        }
        if (link != null) {
            sbWhere.append(" and a.link = :link");
        }
        if (stateUpdatedStart != null) {
            sbWhere.append(" and a.state_updated_at >= :stateUpdatedStart");
        }
        StringBuilder orderClause = new StringBuilder();
        if (sortBy != null && !sortBy.isEmpty()) {
            this.replaceFieldName(sortBy, "alarm_id", "a.id");
            this.replaceFieldName(sortBy, "alarm_definition_id", "ad.id");
            this.replaceFieldName(sortBy, "alarm_definition_name", "ad.name");
            this.replaceFieldName(sortBy, "created_timestamp", "a.created_at");
            this.replaceFieldName(sortBy, "updated_timestamp", "a.updated_at");
            this.replaceFieldName(sortBy, "state_updated_timestamp", "a.state_updated_at");
            this.replaceFieldName(sortBy, "state", "FIELD(state, \"OK\", \"UNDETERMINED\", \"ALARM\")");
            this.replaceFieldName(sortBy, "severity", "FIELD(severity, \"LOW\", \"MEDIUM\", \"HIGH\", \"CRITICAL\")");
            orderClause.append(" order by ");
            orderClause.append(COMMA_JOINER.join(sortBy));
            if (orderClause.indexOf("a.id") == -1) {
                orderClause.append(",a.id ASC");
            }
            orderClause.append(' ');
        } else {
            orderClause.append(" order by a.id ASC ");
        }
        sbWhere.append((CharSequence)orderClause);
        if (enforceLimit && limit > 0) {
            sbWhere.append(" limit :limit");
        }
        if (offset != null) {
            sbWhere.append(" offset ");
            sbWhere.append(offset);
            sbWhere.append(' ');
        }
        sbWhere.append(")");
        String sql = String.format(FIND_ALARMS_SQL, sbWhere, orderClause);
        try (Handle h = this.db.open();){
            Query q = (Query)h.createQuery(sql).bind("tenantId", tenantId);
            if (alarmDefId != null) {
                q.bind("alarmDefId", alarmDefId);
            }
            if (metricName != null) {
                q.bind("metricName", metricName);
            }
            if (state != null) {
                q.bind("state", state.name());
            }
            MySQLUtils.bindSeverityToQuery(q, severities);
            if (lifecycleState != null) {
                q.bind("lifecycleState", lifecycleState);
            }
            if (link != null) {
                q.bind("link", link);
            }
            if (stateUpdatedStart != null) {
                q.bind("stateUpdatedStart", stateUpdatedStart.toString());
            }
            if (enforceLimit && limit > 0) {
                q.bind("limit", limit + 1);
            }
            DimensionQueries.bindDimensionsToQuery(q, metricDimensions);
            List rows = q.list();
            List<Alarm> list = this.createAlarms(tenantId, rows);
            return list;
        }
    }

    private void replaceFieldName(List<String> list, String oldString, String newString) {
        for (int i = 0; i < list.size(); ++i) {
            String listElement = list.get(i);
            String columnName = (String)SPACE_SPLITTER.splitToList((CharSequence)listElement).get(0);
            if (!columnName.equals(oldString)) continue;
            list.set(i, listElement.replace(oldString, newString));
        }
    }

    @Override
    public Alarm findById(String tenantId, String alarmId) {
        try (Handle h = this.db.open();){
            Alarm alarm = this.findAlarm(tenantId, alarmId, h);
            return alarm;
        }
    }

    private Alarm findAlarm(String tenantId, String alarmId, Handle h) {
        String sql = String.format(FIND_ALARM_BY_ID_SQL, " and a.id = :id", "");
        List rows = ((Query)((Query)h.createQuery(sql).bind("id", alarmId)).bind("tenantId", tenantId)).list();
        if (rows.isEmpty()) {
            throw new EntityNotFoundException("No alarm exists for %s", alarmId);
        }
        return this.createAlarms(tenantId, rows).get(0);
    }

    private List<Alarm> createAlarms(String tenantId, List<Map<String, Object>> rows) {
        String previousAlarmId = null;
        LinkedList<Alarm> alarms = new LinkedList<Alarm>();
        ArrayList<MetricDefinition> alarmedMetrics = null;
        for (Map<String, Object> row : rows) {
            String dimensions;
            String alarmId = (String)row.get("alarm_id");
            if (!alarmId.equals(previousAlarmId)) {
                alarmedMetrics = new ArrayList<MetricDefinition>();
                Alarm alarm = new Alarm(alarmId, this.getString(row, "alarm_definition_id"), this.getString(row, "alarm_definition_name"), this.getString(row, "severity"), alarmedMetrics, AlarmState.valueOf((String)this.getString(row, "state")), this.getString(row, "lifecycle_state"), this.getString(row, "link"), new DateTime(((Timestamp)row.get("state_updated_timestamp")).getTime(), DateTimeZone.forID((String)"UTC")), new DateTime(((Timestamp)row.get("updated_timestamp")).getTime(), DateTimeZone.forID((String)"UTC")), new DateTime(((Timestamp)row.get("created_timestamp")).getTime(), DateTimeZone.forID((String)"UTC")));
                alarms.add(alarm);
            }
            previousAlarmId = alarmId;
            HashMap<String, String> dimensionMap = new HashMap<String, String>();
            if (row.containsKey("metric_dimensions") && (dimensions = this.getString(row, "metric_dimensions")) != null && !dimensions.isEmpty()) {
                for (String dimension : dimensions.split(",")) {
                    String[] parsed_dimension = dimension.split("=");
                    if (parsed_dimension.length == 2) {
                        dimensionMap.put(parsed_dimension[0], parsed_dimension[1]);
                        continue;
                    }
                    logger.error("Failed to parse dimension. Dimension is malformed: {}", (Object)dimension);
                }
            }
            alarmedMetrics.add(new MetricDefinition(this.getString(row, "metric_name"), dimensionMap));
        }
        return alarms;
    }

    private String getString(Map<String, Object> row, String fieldName) {
        return (String)row.get(fieldName);
    }

    @Override
    public Alarm update(String tenantId, String id, AlarmState state, String lifecycleState, String link) {
        try (Handle h = this.db.open();){
            h.begin();
            Alarm originalAlarm = this.findAlarm(tenantId, id, h);
            if (!originalAlarm.getState().equals((Object)state)) {
                h.insert("update alarm set state = ?, state_updated_at = NOW() where id = ?", new Object[]{state.name(), id});
            }
            h.insert("update alarm set lifecycle_state = ?, link = ?, updated_at = NOW() where id = ?", new Object[]{lifecycleState, link, id});
            h.commit();
            Alarm alarm = originalAlarm;
            return alarm;
        }
    }

    @Override
    public Map<String, AlarmSubExpression> findAlarmSubExpressions(String alarmId) {
        try (Handle h = this.db.open();){
            List result = ((Query)h.createQuery("select * from sub_alarm where alarm_id = :alarmId").bind("alarmId", alarmId)).map((ResultSetMapper)new BeanMapper(SubAlarm.class)).list();
            HashMap<String, AlarmSubExpression> subAlarms = new HashMap<String, AlarmSubExpression>(result.size());
            for (SubAlarm row : result) {
                subAlarms.put(row.id, AlarmSubExpression.of((String)row.expression));
            }
            HashMap<String, AlarmSubExpression> hashMap = subAlarms;
            return hashMap;
        }
    }

    @Override
    public Map<String, Map<String, AlarmSubExpression>> findAlarmSubExpressionsForAlarmDefinition(String alarmDefinitionId) {
        try (Handle h = this.db.open();){
            List rows = ((Query)h.createQuery("select sa.* from sub_alarm as sa, alarm as a where sa.alarm_id=a.id and a.alarm_definition_id = :alarmDefinitionId").bind("alarmDefinitionId", alarmDefinitionId)).list();
            HashMap subAlarms = new HashMap();
            for (Map row : rows) {
                String alarmId = (String)row.get("alarm_id");
                HashMap<String, AlarmSubExpression> alarmMap = (HashMap<String, AlarmSubExpression>)subAlarms.get(alarmId);
                if (alarmMap == null) {
                    alarmMap = new HashMap<String, AlarmSubExpression>();
                    subAlarms.put(alarmId, alarmMap);
                }
                String id = (String)row.get("id");
                String expression = (String)row.get("expression");
                alarmMap.put(id, AlarmSubExpression.of((String)expression));
            }
            HashMap hashMap = subAlarms;
            return hashMap;
        }
    }

    @Override
    public AlarmCount getAlarmsCount(String tenantId, String alarmDefId, String metricName, Map<String, String> metricDimensions, AlarmState state, List<AlarmSeverity> severities, String lifecycleState, String link, DateTime stateUpdatedStart, List<String> groupBy, String offset, int limit) {
        String SELECT_CLAUSE = "SELECT count(*) as count%1$s  FROM alarm AS a  INNER JOIN alarm_definition as ad on ad.id = a.alarm_definition_id ";
        StringBuilder queryBuilder = new StringBuilder();
        String groupByStr = "";
        if (groupBy != null) {
            groupByStr = COMMA_JOINER.join(groupBy);
            queryBuilder.append(String.format("SELECT count(*) as count%1$s  FROM alarm AS a  INNER JOIN alarm_definition as ad on ad.id = a.alarm_definition_id ", ',' + groupByStr));
            if (groupBy.contains("metric_name") || groupBy.contains("dimension_name") || groupBy.contains("dimension_value")) {
                String metricSelect = " INNER JOIN (SELECT distinct am.alarm_id%1$s FROM metric_definition AS md JOIN metric_definition_dimensions AS mdd on md.id = mdd.metric_definition_id JOIN metric_dimension AS mdim ON mdd.metric_dimension_set_id = mdim.dimension_set_id JOIN alarm_metric AS am ON am.metric_definition_dimensions_id = mdd.id)AS metrics ON a.id = metrics.alarm_id ";
                String subSelect = "";
                if (groupBy.contains("metric_name")) {
                    subSelect = subSelect + ",md.name AS metric_name";
                }
                if (groupBy.contains("dimension_name")) {
                    subSelect = subSelect + ",mdim.name AS dimension_name";
                }
                if (groupBy.contains("dimension_value")) {
                    subSelect = subSelect + ",mdim.value AS dimension_value";
                }
                queryBuilder.append(String.format(metricSelect, subSelect));
            }
        } else {
            queryBuilder.append(String.format("SELECT count(*) as count%1$s  FROM alarm AS a  INNER JOIN alarm_definition as ad on ad.id = a.alarm_definition_id ", groupByStr));
        }
        queryBuilder.append(" INNER JOIN (SELECT a.id FROM alarm AS a, alarm_definition AS ad WHERE ad.id = a.alarm_definition_id   AND ad.deleted_at IS NULL   AND ad.tenant_id = :tenantId ");
        if (alarmDefId != null) {
            queryBuilder.append(" AND ad.id = :alarmDefId ");
        }
        if (metricName != null) {
            queryBuilder.append(" AND a.id IN (SELECT distinct a.id FROM alarm AS a INNER JOIN alarm_metric AS am ON am.alarm_id = a.id INNER JOIN metric_definition_dimensions AS mdd   ON mdd.id = am.metric_definition_dimensions_id INNER JOIN (SELECT distinct id FROM metric_definition             WHERE name = :metricName) AS md   ON md.id = mdd.metric_definition_id ");
            this.buildJoinClauseFor(metricDimensions, queryBuilder);
            queryBuilder.append(")");
        } else if (metricDimensions != null) {
            queryBuilder.append(" AND a.id IN (SELECT distinct a.id FROM alarm AS a INNER JOIN alarm_metric AS am ON am.alarm_id = a.id INNER JOIN metric_definition_dimensions AS mdd   ON mdd.id = am.metric_definition_dimensions_id ");
            this.buildJoinClauseFor(metricDimensions, queryBuilder);
            queryBuilder.append(")");
        }
        if (state != null) {
            queryBuilder.append(" AND a.state = :state");
        }
        queryBuilder.append(MySQLUtils.buildSeverityAndClause(severities));
        if (lifecycleState != null) {
            queryBuilder.append(" AND a.lifecycle_state = :lifecycleState");
        }
        if (link != null) {
            queryBuilder.append(" AND a.link = :link");
        }
        if (stateUpdatedStart != null) {
            queryBuilder.append(" AND a.state_updated_at >= :stateUpdatedStart");
        }
        queryBuilder.append(") AS alarm_id_list ON alarm_id_list.id = a.id ");
        if (groupBy != null) {
            queryBuilder.append(" GROUP BY ");
            queryBuilder.append(groupByStr);
        }
        queryBuilder.append(" ORDER BY ");
        if (!Strings.isNullOrEmpty((String)groupByStr)) {
            queryBuilder.append(groupByStr);
        } else {
            queryBuilder.append(" a.id ");
        }
        queryBuilder.append(" LIMIT :limit");
        if (offset != null) {
            queryBuilder.append(String.format(" OFFSET %1$s ", offset));
        }
        try (Handle h = this.db.open();){
            Query q = (Query)h.createQuery(queryBuilder.toString()).bind("tenantId", tenantId);
            if (alarmDefId != null) {
                q.bind("alarmDefId", alarmDefId);
            }
            if (metricName != null) {
                q.bind("metricName", metricName);
            }
            if (state != null) {
                q.bind("state", state.name());
            }
            MySQLUtils.bindSeverityToQuery(q, severities);
            if (lifecycleState != null) {
                q.bind("lifecycleState", lifecycleState);
            }
            if (link != null) {
                q.bind("link", link);
            }
            if (stateUpdatedStart != null) {
                q.bind("stateUpdatedStart", stateUpdatedStart.toString());
            }
            q.bind("limit", limit + 1);
            DimensionQueries.bindDimensionsToQuery(q, metricDimensions);
            List rows = q.list();
            AlarmCount alarmCount = this.createAlarmCounts(groupBy, rows);
            return alarmCount;
        }
    }

    private AlarmCount createAlarmCounts(List<String> groupBy, List<Map<String, Object>> rows) {
        ArrayList<List<Object>> counts = new ArrayList<List<Object>>();
        if (rows.size() == 0) {
            ArrayList<Integer> countsAndTags = new ArrayList<Integer>();
            countsAndTags.add(0);
            if (groupBy != null) {
                for (String columnName : groupBy) {
                    countsAndTags.add(null);
                }
            }
            counts.add(countsAndTags);
            return new AlarmCount(groupBy, counts);
        }
        for (Map<String, Object> row : rows) {
            ArrayList<Object> countAndTags = new ArrayList<Object>();
            countAndTags.add(row.get("count"));
            if (groupBy != null && !groupBy.isEmpty()) {
                for (String columnName : groupBy) {
                    countAndTags.add(row.get(columnName));
                }
            }
            counts.add(countAndTags);
        }
        return new AlarmCount(groupBy, counts);
    }

    public static class SubAlarm {
        private String id;
        private String expression;

        public SubAlarm() {
        }

        public SubAlarm(String id, String expression) {
            this.id = id;
            this.expression = expression;
        }

        public String getId() {
            return this.id;
        }

        public void setId(String id) {
            this.id = id;
        }

        public String getExpression() {
            return this.expression;
        }

        public void setExpression(String expression) {
            this.expression = expression;
        }
    }
}

