/*
 * Decompiled with CFR 0.152.
 */
package monasca.api.infrastructure.persistence.hibernate;

import org.hibernate.SessionFactory;
import org.hibernate.Transaction;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.Marker;
import org.slf4j.MarkerFactory;

abstract class BaseSqlRepo {
    protected static final Marker ORM_LOG_MARKER = MarkerFactory.getMarker((String)"ORM");
    private static final Logger LOG = LoggerFactory.getLogger(BaseSqlRepo.class);
    protected final SessionFactory sessionFactory;

    protected BaseSqlRepo(SessionFactory sessionFactory) {
        this.sessionFactory = sessionFactory;
    }

    protected void rollbackIfNotNull(Transaction tx) {
        if (tx != null) {
            try {
                tx.rollback();
            }
            catch (RuntimeException rbe) {
                LOG.error(ORM_LOG_MARKER, "Couldn\u2019t roll back transaction", (Throwable)rbe);
            }
        }
    }

    protected DateTime getUTCNow() {
        return DateTime.now((DateTimeZone)DateTimeZone.UTC);
    }
}

