/*
 * Decompiled with CFR 0.152.
 */
package monasca.api.infrastructure.persistence.hibernate;

import com.google.common.base.Function;
import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import com.google.common.base.Splitter;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import javax.inject.Inject;
import javax.inject.Named;
import monasca.api.domain.exception.EntityNotFoundException;
import monasca.api.domain.model.alarm.Alarm;
import monasca.api.domain.model.alarm.AlarmCount;
import monasca.api.domain.model.alarm.AlarmRepo;
import monasca.api.infrastructure.persistence.hibernate.BaseSqlRepo;
import monasca.common.hibernate.db.AlarmDb;
import monasca.common.hibernate.db.SubAlarmDb;
import monasca.common.hibernate.type.BinaryId;
import monasca.common.model.alarm.AlarmSeverity;
import monasca.common.model.alarm.AlarmState;
import monasca.common.model.alarm.AlarmSubExpression;
import monasca.common.model.metric.MetricDefinition;
import monasca.common.util.Conversions;
import org.apache.commons.collections4.CollectionUtils;
import org.hibernate.Query;
import org.hibernate.Session;
import org.hibernate.SessionFactory;
import org.hibernate.Transaction;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Projection;
import org.hibernate.criterion.Projections;
import org.hibernate.criterion.Restrictions;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AlarmSqlRepoImpl
extends BaseSqlRepo
implements AlarmRepo {
    private static final Logger logger = LoggerFactory.getLogger(AlarmSqlRepoImpl.class);
    private static final Joiner COMMA_JOINER = Joiner.on((String)",");
    private static final Joiner SPACE_JOINER = Joiner.on((String)" ");
    private static final Splitter SPACE_SPLITTER = Splitter.on((String)" ");
    private static final AlarmSortByFunction ALARM_SORT_BY_FUNCTION = new AlarmSortByFunction();
    private static final String FIND_ALARM_BY_ID_SQL = "select distinct ad.id as alarm_definition_id, ad.severity, ad.name as alarm_definition_name, a.id, a.state, a.updatedAt, a.createdAt as created_timestamp, md.name as metric_name, mdg.id.name, mdg.value, a.lifecycleState, a.link, a.stateUpdatedAt, mdg.id.dimensionSetId from AlarmDb as a , AlarmDefinitionDb as ad , AlarmMetricDb as am , MetricDefinitionDimensionsDb as mdd , MetricDefinitionDb as md , MetricDimensionDb as mdg where  ad.id = a.alarmDefinition.id  and am.alarmMetricId.alarm.id = a.id  and mdd.id = am.alarmMetricId.metricDefinitionDimensions.id  and md.id = mdd.metricDefinition.id  and mdg.id.dimensionSetId = mdd.metricDimensionSetId  and ad.tenantId = :tenantId  %s  and ad.deletedAt is null order by a.id, mdg.id.dimensionSetId %s";
    private static final String FIND_ALARMS_SQL = "select ad.id as alarm_definition_id, ad.severity, ad.name as alarm_definition_name, a.id, a.state, a.updated_at as updated_timestamp, a.created_at as created_timestamp, md.name as metric_name, mdg.name, mdg.value, a.lifecycle_state, a.link, a.state_updated_at as state_updated_timestamp, mdg.dimension_set_id from alarm as a inner join %s as alarm_id_list on alarm_id_list.id = a.id inner join alarm_definition ad on ad.id = a.alarm_definition_id inner join alarm_metric as am on am.alarm_id = a.id inner join metric_definition_dimensions as mdd on mdd.id = am.metric_definition_dimensions_id inner join metric_definition as md on md.id = mdd.metric_definition_id left outer join (select dimension_set_id, name, value from metric_dimension group by dimension_set_id, name, value) as mdg on mdg.dimension_set_id = mdd.metric_dimension_set_id %s";

    @Inject
    public AlarmSqlRepoImpl(@Named(value="orm") SessionFactory sessionFactory) {
        super(sessionFactory);
    }

    @Override
    public void deleteById(String tenantId, String id) {
        logger.trace(ORM_LOG_MARKER, "deleteById(...) entering");
        Transaction tx = null;
        try (Session session = null;){
            session = this.sessionFactory.openSession();
            tx = session.beginTransaction();
            long result = (Long)session.createCriteria(AlarmDb.class, "a").createAlias("alarmDefinition", "ad").add((Criterion)Restrictions.conjunction((Criterion[])new Criterion[]{Restrictions.eq((String)"a.id", (Object)id), Restrictions.eq((String)"ad.tenantId", (Object)tenantId), Restrictions.eqProperty((String)"a.alarmDefinition.id", (String)"ad.id"), Restrictions.isNull((String)"ad.deletedAt")})).setProjection((Projection)Projections.count((String)"a.id")).setReadOnly(true).uniqueResult();
            if (result < 1L) {
                throw new EntityNotFoundException("No alarm exists for %s", id);
            }
            session.getNamedQuery("Alarm.deleteById").setString("id", id).executeUpdate();
            tx.commit();
            tx = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<Alarm> find(final String tenantId, final String alarmDefId, final String metricName, final Map<String, String> metricDimensions, final AlarmState state, final List<AlarmSeverity> severities, final String lifecycleState, final String link, final DateTime stateUpdatedStart, List<String> sortBy, String offset, final int limit, final boolean enforceLimit) {
        logger.trace(ORM_LOG_MARKER, "find(...) entering");
        Preconditions.checkNotNull((Object)tenantId, (Object)"TenantId is required");
        LinkedList<Alarm> alarms = new LinkedList();
        try (Session session = null;){
            Query query;
            String sortByClause = ALARM_SORT_BY_FUNCTION.apply(sortBy);
            String alarmsSubQuery = this.getFindAlarmsSubQuery(alarmDefId, metricName, metricDimensions, state, severities, lifecycleState, link, stateUpdatedStart, sortBy, offset, limit, enforceLimit);
            final String sql = String.format(FIND_ALARMS_SQL, alarmsSubQuery, sortByClause);
            try {
                session = this.sessionFactory.openSession();
                query = new Function<Session, Query>(){

                    @Nullable
                    public Query apply(@Nullable Session input) {
                        assert (input != null);
                        Query query = input.createSQLQuery(sql).setReadOnly(true);
                        query.setString("tenantId", tenantId);
                        if (alarmDefId != null) {
                            query.setString("alarmDefId", alarmDefId);
                        }
                        if (metricName != null) {
                            query.setString("metricName", metricName);
                        }
                        if (state != null) {
                            query.setString("state", state.name());
                        }
                        if (CollectionUtils.isNotEmpty((Collection)severities)) {
                            if (severities.size() == 1) {
                                query.setString("severity", ((AlarmSeverity)severities.get(0)).name());
                            } else {
                                for (int it = 0; it < severities.size(); ++it) {
                                    query.setString(String.format("severity_%d", it), ((AlarmSeverity)severities.get(it)).name());
                                }
                            }
                        }
                        if (link != null) {
                            query.setString("link", link);
                        }
                        if (lifecycleState != null) {
                            query.setString("lifecycleState", lifecycleState);
                        }
                        if (stateUpdatedStart != null) {
                            query.setDate("stateUpdatedStart", stateUpdatedStart.toDateTime(DateTimeZone.UTC).toDate());
                        }
                        if (enforceLimit && limit > 0) {
                            query.setInteger("limit", limit + 1);
                        }
                        AlarmSqlRepoImpl.this.bindDimensionsToQuery(query, metricDimensions);
                        return query;
                    }
                }.apply(session);
            }
            catch (Exception e) {
                logger.error("Failed to bind query {}, error is {}", (Object)sql, (Object)e.getMessage());
                throw new RuntimeException("Failed to bind query", e);
            }
            List alarmList = query.list();
            if (alarmList.isEmpty()) {
                List<Alarm> list = Collections.emptyList();
                return list;
            }
            alarms = this.createAlarms(alarmList);
        }
        return alarms;
    }

    private String getFindAlarmsSubQuery(String alarmDefId, String metricName, Map<String, String> metricDimensions, AlarmState state, List<AlarmSeverity> severities, String lifecycleState, String link, DateTime stateUpdatedStart, List<String> sortBy, String offset, int limit, boolean enforceLimit) {
        StringBuilder sbWhere = new StringBuilder("(select distinct a.id from alarm as a, alarm_definition as ad where ad.id = a.alarm_definition_id   and ad.deleted_at is null   and ad.tenant_id = :tenantId ");
        if (alarmDefId != null) {
            sbWhere.append(" and ad.id = :alarmDefId ");
        }
        if (metricName != null) {
            sbWhere.append(" and a.id in (select distinct a.id from alarm as a inner join alarm_metric as am on am.alarm_id = a.id inner join metric_definition_dimensions as mdd   on mdd.id = am.metric_definition_dimensions_id inner join (select distinct id from metric_definition             where name = :metricName) as md   on md.id = mdd.metric_definition_id ");
            this.buildJoinClauseFor(metricDimensions, sbWhere);
            sbWhere.append(")");
        } else if (metricDimensions != null) {
            sbWhere.append(" and a.id in (select distinct a.id from alarm as a inner join alarm_metric as am on am.alarm_id = a.id inner join metric_definition_dimensions as mdd   on mdd.id = am.metric_definition_dimensions_id ");
            this.buildJoinClauseFor(metricDimensions, sbWhere);
            sbWhere.append(")");
        }
        if (state != null) {
            sbWhere.append(" and a.state = :state");
        }
        if (CollectionUtils.isNotEmpty(severities)) {
            if (severities.size() == 1) {
                sbWhere.append(" and ad.severity = :severity");
            } else {
                sbWhere.append(" and (");
                for (int i = 0; i < severities.size(); ++i) {
                    sbWhere.append("ad.severity = :severity_").append(i);
                    if (i >= severities.size() - 1) continue;
                    sbWhere.append(" or ");
                }
                sbWhere.append(")");
            }
        }
        if (lifecycleState != null) {
            sbWhere.append(" and a.lifecycle_state = :lifecycleState");
        }
        if (link != null) {
            sbWhere.append(" and a.link = :link");
        }
        if (stateUpdatedStart != null) {
            sbWhere.append(" and a.state_updated_at >= :stateUpdatedStart");
        }
        if (enforceLimit && limit > 0) {
            sbWhere.append(" limit :limit");
        }
        if (offset != null) {
            sbWhere.append(" offset ");
            sbWhere.append(offset);
            sbWhere.append(' ');
        }
        sbWhere.append(")");
        return sbWhere.toString();
    }

    private List<Alarm> createAlarms(List<Object[]> alarmList) {
        LinkedList alarms = Lists.newLinkedList();
        String previousAlarmId = null;
        BinaryId previousDimensionSetId = null;
        ArrayList<MetricDefinition> alarmedMetrics = null;
        HashMap dimensionMap = new HashMap();
        for (Object[] alarmRow : alarmList) {
            String alarmDefinitionId = (String)alarmRow[0];
            AlarmSeverity severity = (AlarmSeverity)Conversions.variantToEnum((Object)alarmRow[1], AlarmSeverity.class);
            AlarmState alarmState = (AlarmState)Conversions.variantToEnum((Object)alarmRow[4], AlarmState.class);
            DateTime updatedTimestamp = Conversions.variantToDateTime((Object)alarmRow[5]);
            DateTime createdTimestamp = Conversions.variantToDateTime((Object)alarmRow[6]);
            BinaryId dimensionSetId = this.convertBinaryId(alarmRow[13]);
            DateTime stateUpdatedTimestamp = Conversions.variantToDateTime((Object)alarmRow[12]);
            String alarm_definition_name = (String)alarmRow[2];
            String id = (String)alarmRow[3];
            String lifecycle_state = (String)alarmRow[10];
            String link = (String)alarmRow[11];
            String metric_name = (String)alarmRow[7];
            String dimension_name = (String)alarmRow[8];
            String dimension_value = (String)alarmRow[9];
            if (!id.equals(previousAlarmId)) {
                alarmedMetrics = new ArrayList<MetricDefinition>();
                dimensionMap = Maps.newHashMap();
                alarmedMetrics.add(new MetricDefinition(metric_name, (Map)dimensionMap));
                alarms.add(new Alarm(id, alarmDefinitionId, alarm_definition_name, severity.name(), alarmedMetrics, alarmState, lifecycle_state, link, stateUpdatedTimestamp, updatedTimestamp, createdTimestamp));
                previousDimensionSetId = dimensionSetId;
            }
            if (!dimensionSetId.equals(previousDimensionSetId)) {
                dimensionMap = Maps.newHashMap();
                alarmedMetrics.add(new MetricDefinition(metric_name, (Map)dimensionMap));
            }
            dimensionMap.put(dimension_name, dimension_value);
            previousDimensionSetId = dimensionSetId;
            previousAlarmId = id;
        }
        return alarms;
    }

    private BinaryId convertBinaryId(Object o) {
        BinaryId dimensionSetId = o instanceof BinaryId ? (BinaryId)o : new BinaryId((byte[])o);
        return dimensionSetId;
    }

    private void bindDimensionsToQuery(Query query, Map<String, String> dimensions) {
        if (dimensions != null) {
            int i = 0;
            for (Map.Entry<String, String> entry : dimensions.entrySet()) {
                query.setString("dname" + i, entry.getKey());
                query.setString("dvalue" + i, entry.getValue());
                ++i;
            }
        }
    }

    private void buildJoinClauseFor(Map<String, String> dimensions, StringBuilder sbJoin) {
        if (dimensions == null) {
            return;
        }
        for (int i = 0; i < dimensions.size(); ++i) {
            String indexStr = String.valueOf(i);
            sbJoin.append(" inner join metric_dimension md").append(indexStr).append(" on md").append(indexStr).append(".name = :dname").append(indexStr).append(" and md").append(indexStr).append(".value = :dvalue").append(indexStr).append(" and mdd.metric_dimension_set_id = md").append(indexStr).append(".dimension_set_id");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Alarm findById(String tenantId, String id) {
        logger.trace(ORM_LOG_MARKER, "findById(...) entering");
        Session session = null;
        String sql = String.format(FIND_ALARM_BY_ID_SQL, " and a.id = :id", "");
        List<Object> alarms = new LinkedList();
        try {
            session = this.sessionFactory.openSession();
            Query qAlarmDefinition = session.createQuery(sql).setString("tenantId", tenantId).setString("id", id);
            List alarmList = qAlarmDefinition.list();
            if (alarmList.isEmpty()) {
                throw new EntityNotFoundException("No alarm exists for %s", id);
            }
            alarms = this.createAlarms(alarmList);
        }
        finally {
            if (session != null) {
                session.close();
            }
        }
        return (Alarm)alarms.get(0);
    }

    @Override
    public Alarm update(String tenantId, String id, AlarmState state, String lifecycleState, String link) {
        Session session = null;
        Alarm originalAlarm = null;
        Transaction tx = null;
        try {
            session = this.sessionFactory.openSession();
            tx = session.beginTransaction();
            originalAlarm = this.findById(tenantId, id);
            AlarmDb result = (AlarmDb)session.getNamedQuery("Alarm.findById").setString("id", id).uniqueResult();
            if (!originalAlarm.getState().equals((Object)state)) {
                result.setStateUpdatedAt(this.getUTCNow());
                result.setState(state);
            }
            result.setUpdatedAt(this.getUTCNow());
            result.setLink(link);
            result.setLifecycleState(lifecycleState);
            session.update((Object)result);
            tx.commit();
            tx = null;
        }
        catch (Exception e) {
            this.rollbackIfNotNull(tx);
            throw e;
        }
        finally {
            if (session != null) {
                session.close();
            }
        }
        return originalAlarm;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Map<String, AlarmSubExpression> findAlarmSubExpressions(String alarmId) {
        Session session = null;
        HashMap subAlarms = Maps.newHashMap();
        logger.debug("AlarmSqlRepoImpl[findAlarmSubExpressions] called");
        try {
            session = this.sessionFactory.openSession();
            List result = session.getNamedQuery("SubAlarm.byAlarmId").setString("id", alarmId).list();
            if (result != null) {
                for (SubAlarmDb row : result) {
                    subAlarms.put(row.getId(), AlarmSubExpression.of((String)row.getExpression()));
                }
            }
        }
        finally {
            if (session != null) {
                session.close();
            }
        }
        return subAlarms;
    }

    @Override
    public Map<String, Map<String, AlarmSubExpression>> findAlarmSubExpressionsForAlarmDefinition(String alarmDefinitionId) {
        logger.trace(ORM_LOG_MARKER, "findAlarmSubExpressionsForAlarmDefinition(...) entering");
        Session session = null;
        Transaction tx = null;
        HashMap subAlarms = Maps.newHashMap();
        try {
            session = this.sessionFactory.openSession();
            tx = session.beginTransaction();
            Iterator rows = session.getNamedQuery("SubAlarm.byAlarmDefinitionId").setString("id", alarmDefinitionId).setReadOnly(true).iterate();
            while (rows.hasNext()) {
                SubAlarmDb row = (SubAlarmDb)rows.next();
                String alarmId = (String)((Object)session.getIdentifier((Object)row.getAlarm()));
                Map alarmMap = (Map)subAlarms.get(alarmId);
                if (alarmMap == null) {
                    alarmMap = Maps.newHashMap();
                    subAlarms.put(alarmId, alarmMap);
                }
                String id = (String)((Object)row.getId());
                String expression = row.getExpression();
                alarmMap.put(id, AlarmSubExpression.of((String)expression));
            }
            tx.commit();
            tx = null;
        }
        catch (Exception exp) {
            this.rollbackIfNotNull(tx);
            throw exp;
        }
        finally {
            if (session != null) {
                session.close();
            }
        }
        return subAlarms;
    }

    @Override
    public AlarmCount getAlarmsCount(String tenantId, String alarmDefId, String metricName, Map<String, String> metricDimensions, AlarmState state, List<AlarmSeverity> severities, String lifecycleState, String link, DateTime stateUpdatedStart, List<String> groupBy, String offset, int limit) {
        return null;
    }

    private static final class CaseWhenSortClauseFunction
    implements Function<List<String>, String> {
        private final String sortOrder;

        CaseWhenSortClauseFunction(String sortOrder) {
            this.sortOrder = sortOrder;
        }

        @Nullable
        public String apply(@Nullable List<String> input) {
            assert (input != null);
            if (input.size() == 1) {
                return String.format("%s %s", input.get(0), this.sortOrder).trim();
            }
            ArrayList builder = Lists.newArrayList((Object[])new String[]{"CASE"});
            boolean ascendingOrder = this.isAscendingOrder();
            for (int it = 0; it < input.size(); ++it) {
                String[] parts = input.get(it).split("=");
                String columnName = parts[0];
                String columnValue = parts[1];
                int orderValue = ascendingOrder ? it : input.size() - it - 1;
                builder.add(String.format("WHEN %s=%s THEN %s", columnName, columnValue, orderValue));
            }
            builder.add(String.format("ELSE %s", input.size()));
            builder.add("END");
            return SPACE_JOINER.join((Iterable)builder);
        }

        private boolean isAscendingOrder() {
            return "".equals(this.sortOrder) || "ASC".equals(this.sortOrder);
        }
    }

    private static class AlarmSortByFunction
    implements Function<List<String>, String> {
        static final Map<String, List<String>> SORT_BY_TO_COLUMN_ALIAS = Maps.newHashMapWithExpectedSize((int)10);

        private AlarmSortByFunction() {
        }

        @Nullable
        public String apply(@Nullable List<String> input) {
            StringBuilder orderClause = new StringBuilder(" ORDER BY ");
            if (CollectionUtils.isEmpty(input)) {
                return orderClause.append("a.id ASC ").toString();
            }
            ArrayList sortByElements = Lists.newArrayListWithExpectedSize((int)input.size());
            boolean alarmIdUsed = false;
            for (String sortByElement : input) {
                List split = SPACE_SPLITTER.splitToList((CharSequence)sortByElement);
                String sortAlias = (String)split.get(0);
                String sortOrder = split.size() >= 2 ? ((String)split.get(1)).toUpperCase() : "";
                List<String> columnAlias = SORT_BY_TO_COLUMN_ALIAS.get(sortAlias);
                alarmIdUsed = "alarm_id".equals(sortAlias);
                if (columnAlias == null) continue;
                sortByElements.add(new CaseWhenSortClauseFunction(sortOrder).apply(columnAlias));
            }
            if (!alarmIdUsed) {
                sortByElements.add("a.id ASC");
            }
            orderClause.append(COMMA_JOINER.join((Iterable)sortByElements));
            return orderClause.toString();
        }

        static {
            SORT_BY_TO_COLUMN_ALIAS.put("alarm_id", Lists.newArrayList((Object[])new String[]{"a.id"}));
            SORT_BY_TO_COLUMN_ALIAS.put("alarm_definition_id", Lists.newArrayList((Object[])new String[]{"ad.id"}));
            SORT_BY_TO_COLUMN_ALIAS.put("alarm_definition_name", Lists.newArrayList((Object[])new String[]{"ad.name"}));
            SORT_BY_TO_COLUMN_ALIAS.put("created_timestamp", Lists.newArrayList((Object[])new String[]{"a.created_at"}));
            SORT_BY_TO_COLUMN_ALIAS.put("updated_timestamp", Lists.newArrayList((Object[])new String[]{"a.updated_at"}));
            SORT_BY_TO_COLUMN_ALIAS.put("state_updated_timestamp", Lists.newArrayList((Object[])new String[]{"a.state_updated_at"}));
            SORT_BY_TO_COLUMN_ALIAS.put("state", Lists.newArrayList((Object[])new String[]{"a.state='OK'", "a.state='UNDETERMINED'", "a.state='ALARM'"}));
            SORT_BY_TO_COLUMN_ALIAS.put("severity", Lists.newArrayList((Object[])new String[]{"ad.severity='LOW'", "ad.severity='MEDIUM'", "ad.severity='HIGH'", "ad.severity='CRITICAL'"}));
        }
    }
}

