/*
 * Decompiled with CFR 0.152.
 */
package monasca.api.domain.model.notificationmethod;

import java.util.List;
import monasca.api.domain.model.common.Link;
import monasca.api.domain.model.common.Linked;
import monasca.common.model.domain.common.AbstractEntity;

public class NotificationMethod
extends AbstractEntity
implements Linked {
    private List<Link> links;
    private String name;
    private String type;
    private String address;
    private int period;

    public NotificationMethod() {
    }

    public NotificationMethod(String id, String name, String type, String address, int period) {
        this.id = id;
        this.name = name;
        this.type = type.toUpperCase();
        this.address = address;
        this.period = period;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        NotificationMethod other = (NotificationMethod)obj;
        if (this.address == null ? other.address != null : !this.address.equals(other.address)) {
            return false;
        }
        if (this.name == null ? other.name != null : !this.name.equals(other.name)) {
            return false;
        }
        if (this.period != other.period) {
            return false;
        }
        return !(this.type == null ? other.type != null : !this.type.equalsIgnoreCase(other.type));
    }

    public String getAddress() {
        return this.address;
    }

    public String getId() {
        return this.id;
    }

    @Override
    public List<Link> getLinks() {
        return this.links;
    }

    public String getName() {
        return this.name;
    }

    public String getType() {
        return this.type;
    }

    public int getPeriod() {
        return this.period;
    }

    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + (this.address == null ? 0 : this.address.hashCode());
        result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
        result = 31 * result + (this.type == null ? 0 : this.type.hashCode());
        result = 31 * result + this.period;
        return result;
    }

    public void setAddress(String address) {
        this.address = address;
    }

    public void setId(String id) {
        this.id = id;
    }

    @Override
    public void setLinks(List<Link> links) {
        this.links = links;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setType(String type) {
        this.type = type.toUpperCase();
    }

    public void setPeriod(int period) {
        this.period = period;
    }
}

