/*
 * Decompiled with CFR 0.152.
 */
package monasca.api.app.validation;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.base.CharMatcher;
import com.google.common.base.Strings;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import monasca.api.resource.exception.Exceptions;

public final class ValueMetaValidation {
    private static final int VALUE_META_MAX_NUMBER = 16;
    private static final int VALUE_META_VALUE_MAX_LENGTH = 2048;
    private static final int VALUE_META_NAME_MAX_LENGTH = 255;
    private static final Map<String, String> EMPTY_VALUE_META = Collections.unmodifiableMap(new HashMap());
    private static final ObjectMapper objectMapper = new ObjectMapper();

    private ValueMetaValidation() {
    }

    public static Map<String, String> normalize(Map<String, String> valueMeta) {
        if (valueMeta == null || valueMeta.isEmpty()) {
            return EMPTY_VALUE_META;
        }
        HashMap<String, String> result = new HashMap<String, String>();
        for (Map.Entry<String, String> entry : valueMeta.entrySet()) {
            String key = CharMatcher.WHITESPACE.trimFrom((CharSequence)entry.getKey());
            result.put(key, entry.getValue());
        }
        return result;
    }

    public static void validate(Map<String, String> valueMetas) {
        if (valueMetas.size() > 16) {
            throw Exceptions.unprocessableEntity("Maximum number of valueMeta key/value pairs is %d", 16);
        }
        for (Map.Entry<String, String> valueMeta : valueMetas.entrySet()) {
            if (valueMeta.getKey() == null) {
                throw Exceptions.unprocessableEntity("valueMeta name cannot be empty", new Object[0]);
            }
            String name = CharMatcher.WHITESPACE.trimFrom((CharSequence)valueMeta.getKey());
            String value = valueMeta.getValue();
            if (value == null) {
                value = "";
            }
            if (Strings.isNullOrEmpty((String)name)) {
                throw Exceptions.unprocessableEntity("valueMeta name cannot be empty", new Object[0]);
            }
            if (name.length() <= 255) continue;
            throw Exceptions.unprocessableEntity("valueMeta name %s must be %d characters or less", name, 255);
        }
        ValueMetaValidation.verifyValueMetaStringLength(valueMetas);
    }

    private static void verifyValueMetaStringLength(Map<String, String> valueMetas) {
        try {
            String valueMetaString = objectMapper.writeValueAsString(valueMetas);
            if (valueMetaString.length() > 2048) {
                throw Exceptions.unprocessableEntity("valueMeta name value combinations %s must be %d characters or less", valueMetaString, 2048);
            }
        }
        catch (JsonProcessingException e) {
            throw Exceptions.unprocessableEntity("Failed to serialize valueMeta combinations %s", valueMetas);
        }
    }
}

