/*
 * Decompiled with CFR 0.152.
 */
package monasca.api.app.command;

import java.util.List;
import javax.annotation.Nullable;
import monasca.api.app.validation.AlarmValidation;
import org.hibernate.validator.constraints.NotEmpty;

public class CreateAlarmDefinitionCommand {
    @NotEmpty
    public String name;
    public String description;
    @NotEmpty
    public String expression;
    public List<String> matchBy;
    public String severity;
    public List<String> alarmActions;
    public List<String> okActions;
    public List<String> undeterminedActions;

    public CreateAlarmDefinitionCommand() {
        this.severity = "LOW";
    }

    public CreateAlarmDefinitionCommand(String name, @Nullable String description, String expression, List<String> matchBy, String severity, List<String> alarmActions, List<String> okActions, List<String> undeterminedActions) {
        this.name = name;
        this.description = description;
        this.expression = expression;
        this.matchBy = matchBy;
        this.alarmActions = alarmActions;
        this.okActions = okActions;
        this.undeterminedActions = undeterminedActions;
        this.severity = severity == null ? "LOW" : severity;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateAlarmDefinitionCommand)) {
            return false;
        }
        CreateAlarmDefinitionCommand other = (CreateAlarmDefinitionCommand)obj;
        if (this.alarmActions == null ? other.alarmActions != null : !this.alarmActions.equals(other.alarmActions)) {
            return false;
        }
        if (this.description == null ? other.description != null : !this.description.equals(other.description)) {
            return false;
        }
        if (this.expression == null ? other.expression != null : !this.expression.equals(other.expression)) {
            return false;
        }
        if (this.matchBy == null ? other.matchBy != null : !this.matchBy.equals(other.matchBy)) {
            return false;
        }
        if (this.name == null ? other.name != null : !this.name.equals(other.name)) {
            return false;
        }
        if (this.okActions == null ? other.okActions != null : !this.okActions.equals(other.okActions)) {
            return false;
        }
        if (this.severity == null ? other.severity != null : !this.severity.equals(other.severity)) {
            return false;
        }
        return !(this.undeterminedActions == null ? other.undeterminedActions != null : !this.undeterminedActions.equals(other.undeterminedActions));
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.alarmActions == null ? 0 : this.alarmActions.hashCode());
        result = 31 * result + (this.description == null ? 0 : this.description.hashCode());
        result = 31 * result + (this.expression == null ? 0 : this.expression.hashCode());
        result = 31 * result + (this.matchBy == null ? 0 : this.matchBy.hashCode());
        result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
        result = 31 * result + (this.okActions == null ? 0 : this.okActions.hashCode());
        result = 31 * result + (this.severity == null ? 0 : this.severity.hashCode());
        result = 31 * result + (this.undeterminedActions == null ? 0 : this.undeterminedActions.hashCode());
        return result;
    }

    public void validate() {
        AlarmValidation.validate(this.name, this.description, this.severity, this.alarmActions, this.okActions, this.undeterminedActions);
    }
}

