/*
 * Decompiled with CFR 0.152.
 */
package monasca.api.resource;

import com.codahale.metrics.annotation.Timed;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import javax.inject.Inject;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.UriInfo;
import monasca.api.ApiConfig;
import monasca.api.domain.model.notificationmethod.NotificationMethodType;
import monasca.api.domain.model.notificationmethod.NotificationMethodTypesRepo;
import monasca.api.infrastructure.persistence.PersistUtils;
import monasca.api.resource.Links;

@Path(value="/v2.0/notification-methods/types")
public class NotificationMethodTypesResource {
    NotificationMethodTypesRepo repo = null;
    private final PersistUtils persistUtils;

    @Inject
    public NotificationMethodTypesResource(ApiConfig config, NotificationMethodTypesRepo repo, PersistUtils persistUtils) {
        this.repo = repo;
        this.persistUtils = persistUtils;
    }

    @GET
    @Timed
    @Produces(value={"application/json"})
    public Object list(@Context UriInfo uriInfo, @QueryParam(value="sort_by") String sortByStr, @QueryParam(value="offset") String offset, @QueryParam(value="limit") String limit) throws UnsupportedEncodingException {
        ArrayList<NotificationMethodType> resources = new ArrayList<NotificationMethodType>();
        for (String method_type : this.repo.listNotificationMethodTypes()) {
            resources.add(new NotificationMethodType(method_type));
        }
        int paging_limit = this.persistUtils.getLimit(limit);
        return Links.paginate(paging_limit, resources, uriInfo);
    }
}

