/*
 * Decompiled with CFR 0.152.
 */
package monasca.api.infrastructure.persistence.vertica;

import com.google.common.base.Splitter;
import com.google.common.base.Strings;
import java.sql.Timestamp;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import monasca.api.domain.exception.MultipleMetricsException;
import monasca.api.domain.model.measurement.Measurements;
import org.joda.time.DateTime;
import org.skife.jdbi.v2.Handle;
import org.skife.jdbi.v2.Query;

final class MetricQueries {
    private static final Splitter BAR_SPLITTER = Splitter.on((char)'|').omitEmptyStrings().trimResults();
    private static final Splitter UNDERSCORE_SPLITTER = Splitter.on((char)'_').omitEmptyStrings().trimResults();
    private static final Splitter COMMA_SPLITTER = Splitter.on((char)',').omitEmptyStrings().trimResults();
    static final String FIND_METRIC_DEFS_SQL = "SELECT %s TO_HEX(defDims.id) as defDimsId, def.name, dims.name as dName, dims.value AS dValue FROM MonMetrics.Definitions def JOIN MonMetrics.DefinitionDimensions defDims ON def.id = defDims.definition_id LEFT OUTER JOIN MonMetrics.Dimensions dims ON dims.dimension_set_id = defDims.dimension_set_id WHERE TO_HEX(defDims.id) in (%s) ORDER BY defDims.id ASC";
    static final String METRIC_DEF_SUB_SQL = "SELECT TO_HEX(defDimsSub.id) as id FROM MonMetrics.Definitions as defSub JOIN MonMetrics.DefinitionDimensions as defDimsSub ON defDimsSub.definition_id = defSub.id %s WHERE defSub.tenant_id = :tenantId %s %s %s GROUP BY defDimsSub.id";
    private static final String MEASUREMENT_AND_CLAUSE = "AND time_stamp >= :startTime ";
    private static final String MEASUREMENT_JOIN = "JOIN MonMetrics.Measurements AS meas ON defDimsSub.id = meas.definition_dimensions_id";
    private static final String TABLE_TO_JOIN_ON = "defDimsSub";

    private MetricQueries() {
    }

    static String buildMetricDefinitionSubSql(String name, Map<String, String> dimensions, DateTime startTime, DateTime endTime) {
        String namePart = "";
        if (name != null && !name.isEmpty()) {
            namePart = "AND defSub.name = :name ";
        }
        return String.format(METRIC_DEF_SUB_SQL, MetricQueries.buildTimeJoin(startTime), namePart, MetricQueries.buildDimensionAndClause(dimensions, TABLE_TO_JOIN_ON), MetricQueries.buildTimeAndClause(startTime, endTime));
    }

    static String buildDimensionAndClause(Map<String, String> dimensions, String tableToJoinName) {
        if (dimensions == null || dimensions.isEmpty()) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        sb.append(" and ").append(tableToJoinName).append(".id in ( SELECT defDimsSub2.id FROM MonMetrics.Dimensions AS dimSub JOIN MonMetrics.DefinitionDimensions AS defDimsSub2 ON defDimsSub2.dimension_set_id = dimSub.dimension_set_id WHERE (");
        int i = 0;
        Iterator<Map.Entry<String, String>> it = dimensions.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry<String, String> entry = it.next();
            sb.append("(name = :dname").append(i);
            String dim_value = entry.getValue();
            if (!Strings.isNullOrEmpty((String)dim_value)) {
                List values = BAR_SPLITTER.splitToList((CharSequence)dim_value);
                if (values.size() > 1) {
                    sb.append(" and ( ");
                    for (int j = 0; j < values.size(); ++j) {
                        sb.append("value = :dvalue").append(i).append('_').append(j);
                        if (j >= values.size() - 1) continue;
                        sb.append(" or ");
                    }
                    sb.append(")");
                } else {
                    sb.append(" and value = :dvalue").append(i);
                }
            }
            sb.append(")");
            if (it.hasNext()) {
                sb.append(" or ");
            }
            ++i;
        }
        sb.append(") GROUP BY defDimsSub2.id,dimSub.dimension_set_id HAVING count(*) = ").append(dimensions.size()).append(") ");
        return sb.toString();
    }

    static String buildTimeAndClause(DateTime startTime, DateTime endTime) {
        if (startTime == null) {
            return "";
        }
        StringBuilder timeAndClause = new StringBuilder();
        timeAndClause.append(MEASUREMENT_AND_CLAUSE);
        if (endTime != null) {
            timeAndClause.append("AND time_stamp <= :endTime ");
        }
        return timeAndClause.toString();
    }

    static String buildTimeJoin(DateTime startTime) {
        if (startTime == null) {
            return "";
        }
        return MEASUREMENT_JOIN;
    }

    static void bindDimensionsToQuery(Query<?> query, Map<String, String> dimensions) {
        if (dimensions != null) {
            int i = 0;
            for (Map.Entry<String, String> entry : dimensions.entrySet()) {
                query.bind("dname" + i, entry.getKey());
                if (!Strings.isNullOrEmpty((String)entry.getValue())) {
                    List values = BAR_SPLITTER.splitToList((CharSequence)entry.getValue());
                    if (values.size() > 1) {
                        for (int j = 0; j < values.size(); ++j) {
                            query.bind("dvalue" + i + '_' + j, (String)values.get(j));
                        }
                    } else {
                        query.bind("dvalue" + i, entry.getValue());
                    }
                }
                ++i;
            }
        }
    }

    static void bindOffsetToQuery(Query<Map<String, Object>> query, String offset) {
        List offsets = UNDERSCORE_SPLITTER.splitToList((CharSequence)offset);
        if (offsets.size() > 1) {
            query.bind("offset_id", (String)offsets.get(0));
            query.bind("offset_timestamp", new Timestamp(DateTime.parse((String)((String)offsets.get(1))).getMillis()));
        } else {
            query.bind("offset_timestamp", new Timestamp(DateTime.parse((String)((String)offsets.get(0))).getMillis()));
        }
    }

    static void checkForMultipleDefinitions(Handle h, String tenantId, String name, Map<String, String> dimensions) throws MultipleMetricsException {
        String namePart = "";
        if (name != null && !name.isEmpty()) {
            namePart = "AND name = :name ";
        }
        String sql = String.format(METRIC_DEF_SUB_SQL, "", namePart, MetricQueries.buildDimensionAndClause(dimensions, TABLE_TO_JOIN_ON), "") + " limit 2";
        Query query = h.createQuery(sql);
        query.bind("tenantId", tenantId);
        if (name != null) {
            query.bind("name", name);
        }
        MetricQueries.bindDimensionsToQuery(query, dimensions);
        List rows = query.list();
        if (rows.size() > 1) {
            throw new MultipleMetricsException(name, dimensions);
        }
    }

    static void addDefsToResults(Map<String, ? extends Measurements> results, Handle h, String dbHint) {
        StringBuilder sb = new StringBuilder();
        boolean first = true;
        for (String id : results.keySet()) {
            if (first) {
                sb.append("'").append(id).append("'");
                first = false;
                continue;
            }
            sb.append(',').append("'").append(id).append("'");
        }
        String defDimSql = String.format(FIND_METRIC_DEFS_SQL, dbHint, sb.toString());
        Query query = h.createQuery(defDimSql);
        List rows = query.list();
        String currentDefDimId = null;
        HashMap<String, String> dims = null;
        for (Map row : rows) {
            String defDimId = (String)row.get("defDimsId");
            String defName = (String)row.get("name");
            String dimName = (String)row.get("dName");
            String dimValue = (String)row.get("dValue");
            if (defDimId != null && !defDimId.equals(currentDefDimId)) {
                currentDefDimId = defDimId;
                dims = new HashMap<String, String>();
                if (dimName != null && dimValue != null) {
                    dims.put(dimName, dimValue);
                }
                results.get(defDimId).setId(defDimId);
                results.get(defDimId).setName(defName);
                results.get(defDimId).setDimensions(dims);
                continue;
            }
            if (dimName == null || dimValue == null) continue;
            dims.put(dimName, dimValue);
        }
    }

    static Map<String, String> combineGroupByAndValues(List<String> groupBy, String valueStr) {
        List values = COMMA_SPLITTER.splitToList((CharSequence)valueStr);
        HashMap<String, String> newDimensions = new HashMap<String, String>();
        for (int i = 0; i < groupBy.size(); ++i) {
            newDimensions.put(groupBy.get(i), (String)values.get(i));
        }
        return newDimensions;
    }

    static String buildGroupByConcatString(List<String> groupBy) {
        if (groupBy.isEmpty() || "*".equals(groupBy.get(0))) {
            return "";
        }
        String select = "(";
        for (int i = 0; i < groupBy.size(); ++i) {
            if (i > 0) {
                select = select + " || ',' || ";
            }
            select = select + "gb" + i + ".value";
        }
        select = select + ")";
        return select;
    }

    static String buildGroupByCommaString(List<String> groupBy) {
        String result = "";
        if (!groupBy.contains("*")) {
            for (int i = 0; i < groupBy.size(); ++i) {
                if (i > 0) {
                    result = result + ',';
                }
                result = result + "gb" + i + ".value";
            }
        }
        return result;
    }

    static String buildGroupBySql(List<String> groupBy) {
        if (groupBy.isEmpty() || "*".equals(groupBy.get(0))) {
            return "";
        }
        StringBuilder groupBySql = new StringBuilder(" JOIN MonMetrics.DefinitionDimensions as dd on dd.id = mes.definition_dimensions_id ");
        for (int i = 0; i < groupBy.size(); ++i) {
            groupBySql.append("JOIN (SELECT dimension_set_id,value FROM MonMetrics.Dimensions WHERE name = ");
            groupBySql.append(":groupBy").append(i).append(") as gb").append(i);
            groupBySql.append(" ON gb").append(i).append(".dimension_set_id = dd.dimension_set_id ");
        }
        return groupBySql.toString();
    }

    static void bindGroupBy(Query<Map<String, Object>> query, List<String> groupBy) {
        int i = 0;
        for (String value : groupBy) {
            query.bind("groupBy" + i, value);
            ++i;
        }
    }
}

