/*
 * Decompiled with CFR 0.152.
 */
package monasca.api.infrastructure.persistence.mysql;

import com.google.inject.Inject;
import java.util.List;
import java.util.Map;
import javax.inject.Named;
import monasca.api.infrastructure.persistence.Utils;
import monasca.common.model.alarm.AlarmSeverity;
import org.skife.jdbi.v2.DBI;
import org.skife.jdbi.v2.Handle;
import org.skife.jdbi.v2.Query;
import org.skife.jdbi.v2.tweak.ResultSetMapper;
import org.skife.jdbi.v2.util.StringMapper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MySQLUtils
extends Utils {
    private static final Logger logger = LoggerFactory.getLogger(MySQLUtils.class);
    private final DBI mysql;

    @Inject
    public MySQLUtils(@Named(value="mysql") DBI mysql) {
        this.mysql = mysql;
    }

    @Override
    public List<String> findAlarmIds(String tenantId, Map<String, String> dimensions) {
        List alarmIdList;
        String FIND_ALARM_IDS_SQL = "select distinct a.id from alarm as a join alarm_definition as ad on a.alarm_definition_id = ad.id %s where ad.tenant_id = :tenantId and ad.deleted_at is NULL order by ad.created_at";
        try (Handle h = this.mysql.open();){
            String sql = String.format("select distinct a.id from alarm as a join alarm_definition as ad on a.alarm_definition_id = ad.id %s where ad.tenant_id = :tenantId and ad.deleted_at is NULL order by ad.created_at", this.buildJoinClauseFor(dimensions));
            Query query = (Query)h.createQuery(sql).bind("tenantId", tenantId);
            logger.debug("mysql sql: {}", (Object)sql);
            this.bindDimensionsToQuery(query, dimensions);
            alarmIdList = query.map((ResultSetMapper)StringMapper.FIRST).list();
        }
        return alarmIdList;
    }

    private void bindDimensionsToQuery(Query query, Map<String, String> dimensions) {
        if (dimensions != null) {
            int i = 0;
            for (Map.Entry<String, String> entry : dimensions.entrySet()) {
                query.bind("dname" + i, entry.getKey());
                query.bind("dvalue" + i, entry.getValue());
                ++i;
            }
        }
    }

    public static String buildSeverityAndClause(List<AlarmSeverity> severities) {
        StringBuilder sbWhere = new StringBuilder();
        if (severities != null && !severities.isEmpty()) {
            sbWhere.append(" and (");
            for (int i = 0; i < severities.size(); ++i) {
                sbWhere.append("ad.severity = :severity").append(i);
                if (i >= severities.size() - 1) continue;
                sbWhere.append(" or ");
            }
            sbWhere.append(") ");
        }
        return sbWhere.toString();
    }

    public static void bindSeverityToQuery(Query query, List<AlarmSeverity> severities) {
        if (severities != null && !severities.isEmpty()) {
            for (int i = 0; i < severities.size(); ++i) {
                query.bind("severity" + String.valueOf(i), severities.get(i).name());
            }
        }
    }
}

