/*
 * Decompiled with CFR 0.152.
 */
package monasca.api.infrastructure.persistence;

import com.google.inject.Inject;
import java.text.ParseException;
import java.util.Date;
import monasca.api.ApiConfig;
import org.joda.time.format.DateTimeFormatter;
import org.joda.time.format.ISODateTimeFormat;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PersistUtils {
    private static final Logger logger = LoggerFactory.getLogger(PersistUtils.class);
    private int maxQueryLimit;
    private final int DEFAULT_MAX_QUERY_LIMIT = 10000;
    private DateTimeFormatter isoFormat = ISODateTimeFormat.dateTime();

    @Inject
    public PersistUtils(ApiConfig config) {
        this.setMaxQueryLimit(config.maxQueryLimit);
    }

    private void setMaxQueryLimit(int maxQueryLimit) {
        if (maxQueryLimit <= 0) {
            logger.warn(String.format("Found invalid maxQueryLimit: [%1d]. maxQueryLimit must be a positive integer.", maxQueryLimit));
            logger.warn(String.format("Setting maxQueryLimit to default: [%1d]", 10000));
            logger.warn("Please check your config file for a valid maxQueryLimit property");
            this.maxQueryLimit = 10000;
        } else {
            this.maxQueryLimit = maxQueryLimit;
        }
    }

    public PersistUtils(int maxQueryLimit) {
        this.setMaxQueryLimit(maxQueryLimit);
    }

    public PersistUtils() {
        this.maxQueryLimit = 10000;
    }

    public int getLimit(String limit) {
        int limitInt;
        if (limit == null || limit.isEmpty()) {
            return this.maxQueryLimit;
        }
        try {
            limitInt = Integer.parseInt(limit);
        }
        catch (NumberFormatException e) {
            throw new IllegalArgumentException(String.format("Found invalid Limit: '%1$s'. Limit must be a positive integer.", limit));
        }
        if (limitInt <= 0) {
            throw new IllegalArgumentException(String.format("Found invalid Limit: '%1$s'. Limit must be a positive integer.", limit));
        }
        if (limitInt <= this.maxQueryLimit) {
            return limitInt;
        }
        return this.maxQueryLimit;
    }

    public Date parseTimestamp(String timestampString) throws ParseException {
        return this.isoFormat.parseDateTime(timestampString.trim().replace(' ', 'T')).toDate();
    }
}

