/*
 * Decompiled with CFR 0.152.
 */
package monasca.api.infrastructure.persistence;

import com.google.common.base.Splitter;
import com.google.common.base.Strings;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.skife.jdbi.v2.Query;

public final class DimensionQueries {
    private DimensionQueries() {
    }

    public static void bindDimensionsToQuery(Query<?> query, Map<String, String> dimensions) {
        if (dimensions != null) {
            int i = 0;
            for (Map.Entry<String, String> entry : dimensions.entrySet()) {
                query.bind("dname" + i, entry.getKey());
                if (!Strings.isNullOrEmpty((String)entry.getValue())) {
                    List values = Splitter.on((char)'|').splitToList((CharSequence)entry.getValue());
                    int j = 0;
                    for (String value : values) {
                        query.bind("dvalue" + i + '_' + j, value);
                        ++j;
                    }
                }
                ++i;
            }
        }
    }

    public static Map<String, String> dimensionsFor(String dimensionSet) {
        Map<String, String> dimensions = Collections.emptyMap();
        if (dimensionSet != null) {
            dimensions = new HashMap<String, String>();
            for (String kvStr : dimensionSet.split(",")) {
                String[] kv = kvStr.split("=");
                if (kv.length <= 1) continue;
                dimensions.put(kv[0], kv[1]);
            }
        }
        return dimensions;
    }
}

