/*
 * Decompiled with CFR 0.152.
 */
package monasca.api.domain.model.measurement;

import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import monasca.common.model.domain.common.AbstractEntity;

public class Measurements
extends AbstractEntity
implements Comparable<Measurements> {
    private static final List<String> COLUMNS = Arrays.asList("timestamp", "value", "value_meta");
    protected String name;
    protected Map<String, String> dimensions;
    protected List<String> columns = COLUMNS;
    protected List<List<Object>> measurements;

    public Measurements() {
        this.measurements = new LinkedList<List<Object>>();
    }

    public Measurements(String name, Map<String, String> dimensions, List<List<Object>> measurements) {
        this.name = name;
        this.dimensions = dimensions;
        this.measurements = measurements;
    }

    public Measurements(String name, Map<String, String> dimensions) {
        this.name = name;
        this.dimensions = dimensions;
        this.measurements = new LinkedList<List<Object>>();
    }

    public void addMeasurement(List<Object> measurement) {
        this.measurements.add(measurement);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Measurements other = (Measurements)obj;
        if (this.dimensions == null ? other.dimensions != null : !this.dimensions.equals(other.dimensions)) {
            return false;
        }
        if (this.measurements == null ? other.measurements != null : !this.measurements.equals(other.measurements)) {
            return false;
        }
        if (this.name == null ? other.name != null : !this.name.equals(other.name)) {
            return false;
        }
        return !(this.columns == null ? other.columns != null : !this.columns.equals(other.columns));
    }

    public List<String> getColumns() {
        return this.columns;
    }

    public Map<String, String> getDimensions() {
        return this.dimensions;
    }

    public List<List<Object>> getMeasurements() {
        return this.measurements;
    }

    public String getName() {
        return this.name;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.dimensions == null ? 0 : this.dimensions.hashCode());
        result = 31 * result + (this.measurements == null ? 0 : this.measurements.hashCode());
        result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
        result = 31 * result + (this.columns == null ? 0 : this.columns.hashCode());
        return result;
    }

    public void setDimensions(Map<String, String> dimensions) {
        this.dimensions = dimensions;
    }

    public void setMeasurements(List<List<Object>> measurements) {
        this.measurements = measurements;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String toString() {
        return String.format("Measurement [name=%s, dimensions=%s, measurements=%s]", this.name, this.dimensions, this.measurements);
    }

    @Override
    public int compareTo(Measurements other) {
        return this.id.compareTo(other.getId());
    }
}

