/*
 * Decompiled with CFR 0.152.
 */
package monasca.api.app.command;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.List;
import javax.validation.constraints.Size;
import monasca.api.app.validation.NotificationMethodValidation;
import monasca.api.app.validation.Validation;

public class PatchNotificationMethodCommand {
    @Size(min=1, max=250)
    public String name;
    public String type;
    @Size(min=1, max=512)
    public String address;
    public String period;
    private int convertedPeriod = 0;

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        PatchNotificationMethodCommand other = (PatchNotificationMethodCommand)obj;
        if (this.address == null ? other.address != null : !this.address.equals(other.address)) {
            return false;
        }
        if (this.name == null ? other.name != null : !this.name.equals(other.name)) {
            return false;
        }
        if (this.period == null ? other.period != null : !this.period.equals(other.period)) {
            return false;
        }
        if (this.type == null ? other.type != null : !this.type.equalsIgnoreCase(other.type)) {
            return false;
        }
        return this.convertedPeriod == other.convertedPeriod;
    }

    public void validate(List<Integer> validPeriods) {
        NotificationMethodValidation.validate(this.type, this.address, this.convertedPeriod, validPeriods);
    }

    @JsonProperty(value="period")
    public void setPeriod(String period) {
        this.period = period;
        this.convertedPeriod = Validation.parseAndValidateNumber(period, "period");
    }

    @JsonIgnore
    public void setPeriod(int period) {
        this.convertedPeriod = period;
    }

    public void setType(String type) {
        this.type = type == null ? null : type.toUpperCase();
    }

    public int getConvertedPeriod() {
        return this.convertedPeriod;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
        result = 31 * result + (this.type == null ? 0 : this.type.hashCode());
        result = 31 * result + (this.address == null ? 0 : this.address.hashCode());
        result = 31 * result + (this.period == null ? 0 : this.period.hashCode());
        result = 31 * result + this.convertedPeriod;
        return result;
    }
}

