/*
 * Decompiled with CFR 0.152.
 */
package monasca.api.app;

import com.google.common.collect.HashBiMap;
import com.google.common.collect.Sets;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import javax.annotation.Nullable;
import javax.inject.Inject;
import kafka.javaapi.producer.Producer;
import kafka.producer.KeyedMessage;
import monasca.api.ApiConfig;
import monasca.api.app.AlarmService;
import monasca.api.app.command.UpdateAlarmDefinitionCommand;
import monasca.api.app.validation.DimensionValidation;
import monasca.api.domain.exception.EntityExistsException;
import monasca.api.domain.model.alarm.Alarm;
import monasca.api.domain.model.alarm.AlarmRepo;
import monasca.api.domain.model.alarmdefinition.AlarmDefinition;
import monasca.api.domain.model.alarmdefinition.AlarmDefinitionRepo;
import monasca.api.domain.model.notificationmethod.NotificationMethodRepo;
import monasca.common.model.alarm.AlarmExpression;
import monasca.common.model.alarm.AlarmSubExpression;
import monasca.common.model.event.AlarmDefinitionCreatedEvent;
import monasca.common.model.event.AlarmDefinitionDeletedEvent;
import monasca.common.model.event.AlarmDefinitionUpdatedEvent;
import monasca.common.model.event.AlarmDeletedEvent;
import monasca.common.model.metric.MetricDefinition;
import monasca.common.util.Exceptions;
import monasca.common.util.Serialization;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AlarmDefinitionService {
    private static final Logger LOG = LoggerFactory.getLogger(AlarmService.class);
    private final ApiConfig config;
    private final Producer<String, String> producer;
    private final AlarmDefinitionRepo repo;
    private final AlarmRepo alarmRepo;
    private final NotificationMethodRepo notificationMethodRepo;
    long eventCount;

    @Inject
    public AlarmDefinitionService(ApiConfig config, Producer<String, String> producer, AlarmDefinitionRepo repo, AlarmRepo alarmRepo, NotificationMethodRepo notificationMethodRepo) {
        this.config = config;
        this.producer = producer;
        this.repo = repo;
        this.alarmRepo = alarmRepo;
        this.notificationMethodRepo = notificationMethodRepo;
    }

    public AlarmDefinition create(String tenantId, String name, @Nullable String description, String severity, String expression, AlarmExpression alarmExpression, List<String> matchBy, List<String> alarmActions, @Nullable List<String> okActions, @Nullable List<String> undeterminedActions) {
        String alarmDefID = this.repo.exists(tenantId, name);
        if (alarmDefID != null) {
            throw new EntityExistsException("An alarm definition already exists for project / tenant: %s named: %s", tenantId, name);
        }
        DimensionValidation.validateNames(matchBy);
        this.assertActionsExist(tenantId, alarmActions, okActions, undeterminedActions);
        HashMap<String, AlarmSubExpression> subAlarms = new HashMap<String, AlarmSubExpression>();
        for (AlarmSubExpression subExpression : alarmExpression.getSubExpressions()) {
            subAlarms.put(UUID.randomUUID().toString(), subExpression);
        }
        String alarmDefId = UUID.randomUUID().toString();
        AlarmDefinition alarm = null;
        try {
            LOG.debug("Creating alarm definition {} for tenant {}", (Object)name, (Object)tenantId);
            alarm = this.repo.create(tenantId, alarmDefId, name, description, severity, expression, subAlarms, matchBy, alarmActions, okActions, undeterminedActions);
            String event = Serialization.toJson((Object)new AlarmDefinitionCreatedEvent(tenantId, alarmDefId, name, description, expression, subAlarms, matchBy));
            this.producer.send(new KeyedMessage(this.config.eventsTopic, (Object)String.valueOf(this.eventCount++), (Object)event));
            return alarm;
        }
        catch (Exception e) {
            if (alarm != null) {
                try {
                    this.repo.deleteById(tenantId, alarm.getId());
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            throw Exceptions.uncheck((Exception)e, (String)"Error creating alarm definition for project / tenant %s", (Object[])new Object[]{tenantId});
        }
    }

    public void delete(String tenantId, String alarmDefId) {
        Map<String, MetricDefinition> subAlarmMetricDefs = this.repo.findSubAlarmMetricDefinitions(alarmDefId);
        List<Alarm> alarms = this.alarmRepo.find(tenantId, alarmDefId, null, null, null, null, null, null, null, null, null, 1, false);
        Map<String, Map<String, AlarmSubExpression>> alarmSubExpressions = this.alarmRepo.findAlarmSubExpressionsForAlarmDefinition(alarmDefId);
        this.repo.deleteById(tenantId, alarmDefId);
        String event = Serialization.toJson((Object)new AlarmDefinitionDeletedEvent(alarmDefId, subAlarmMetricDefs));
        this.producer.send(new KeyedMessage(this.config.eventsTopic, (Object)String.valueOf(this.eventCount++), (Object)event));
        for (Alarm alarm : alarms) {
            String alarmDeletedEvent = Serialization.toJson((Object)new AlarmDeletedEvent(tenantId, alarm.getId(), alarm.getMetrics(), alarmDefId, alarmSubExpressions.get(alarm.getId())));
            this.producer.send(new KeyedMessage(this.config.eventsTopic, (Object)String.valueOf(this.eventCount++), (Object)alarmDeletedEvent));
        }
    }

    public AlarmDefinition update(String tenantId, String alarmDefId, AlarmExpression alarmExpression, UpdateAlarmDefinitionCommand command) {
        AlarmDefinition oldAlarmDefinition = this.assertAlarmDefinitionExists(tenantId, alarmDefId, command.alarmActions, command.okActions, command.undeterminedActions);
        SubExpressions subExpressions = this.subExpressionsFor(this.repo.findSubExpressions(alarmDefId), alarmExpression);
        String alarmID = this.repo.exists(tenantId, command.name);
        if (alarmID != null && !alarmID.equalsIgnoreCase(alarmDefId)) {
            throw new EntityExistsException("An alarm definition with the same name already exists for project / tenant: %s named: %s", tenantId, command.name);
        }
        this.validateChangesAllowed(command.matchBy, oldAlarmDefinition, subExpressions);
        this.updateInternal(tenantId, alarmDefId, false, command.name, command.description, command.expression, command.matchBy, command.severity, alarmExpression, command.actionsEnabled, command.alarmActions, command.okActions, command.undeterminedActions, subExpressions);
        return new AlarmDefinition(alarmDefId, command.name, command.description, command.severity, command.expression, command.matchBy, command.actionsEnabled, command.alarmActions, command.okActions, command.undeterminedActions);
    }

    private void validateChangesAllowed(List<String> newMatchBy, AlarmDefinition oldAlarmDefinition, SubExpressions subExpressions) {
        boolean matchBySame = oldAlarmDefinition.getMatchBy() == null || oldAlarmDefinition.getMatchBy().isEmpty() ? newMatchBy == null || newMatchBy.isEmpty() : oldAlarmDefinition.getMatchBy().equals(newMatchBy);
        if (!matchBySame) {
            throw monasca.api.resource.exception.Exceptions.unprocessableEntity("match_by must not change", new Object[0]);
        }
        if (!subExpressions.oldAlarmSubExpressions.isEmpty() || !subExpressions.newAlarmSubExpressions.isEmpty()) {
            int newCount = subExpressions.newAlarmSubExpressions.size() + subExpressions.changedSubExpressions.size() + subExpressions.unchangedSubExpressions.size();
            if (newCount != AlarmExpression.of((String)oldAlarmDefinition.getExpression()).getSubExpressions().size()) {
                throw monasca.api.resource.exception.Exceptions.unprocessableEntity("number of subexpressions must not change", new Object[0]);
            }
            throw monasca.api.resource.exception.Exceptions.unprocessableEntity("metrics in subexpression must not change", new Object[0]);
        }
    }

    public AlarmDefinition patch(String tenantId, String alarmDefId, String name, String description, String severity, String expression, AlarmExpression alarmExpression, List<String> matchBy, Boolean enabled, List<String> alarmActions, List<String> okActions, List<String> undeterminedActions) {
        AlarmDefinition oldAlarmDefinition = this.assertAlarmDefinitionExists(tenantId, alarmDefId, alarmActions, okActions, undeterminedActions);
        String alarmID = this.repo.exists(tenantId, name = name == null ? oldAlarmDefinition.getName() : name);
        if (alarmID != null && !alarmID.equalsIgnoreCase(alarmDefId)) {
            throw new EntityExistsException("An alarm definition with the same name already exists for project / tenant: %s named: %s", tenantId, name);
        }
        description = description == null ? oldAlarmDefinition.getDescription() : description;
        expression = expression == null ? oldAlarmDefinition.getExpression() : expression;
        severity = severity == null ? oldAlarmDefinition.getSeverity() : severity;
        alarmExpression = alarmExpression == null ? AlarmExpression.of((String)expression) : alarmExpression;
        enabled = enabled == null ? oldAlarmDefinition.isActionsEnabled() : enabled.booleanValue();
        matchBy = matchBy == null ? oldAlarmDefinition.getMatchBy() : matchBy;
        SubExpressions subExpressions = this.subExpressionsFor(this.repo.findSubExpressions(alarmDefId), alarmExpression);
        this.validateChangesAllowed(matchBy, oldAlarmDefinition, subExpressions);
        this.updateInternal(tenantId, alarmDefId, true, name, description, expression, matchBy, severity, alarmExpression, enabled, alarmActions, okActions, undeterminedActions, subExpressions);
        return new AlarmDefinition(alarmDefId, name, description, severity, expression, matchBy, enabled, alarmActions == null ? oldAlarmDefinition.getAlarmActions() : alarmActions, okActions == null ? oldAlarmDefinition.getOkActions() : okActions, undeterminedActions == null ? oldAlarmDefinition.getUndeterminedActions() : undeterminedActions);
    }

    private void updateInternal(String tenantId, String alarmDefId, boolean patch, String name, String description, String expression, List<String> matchBy, String severity, AlarmExpression alarmExpression, Boolean enabled, List<String> alarmActions, List<String> okActions, List<String> undeterminedActions, SubExpressions subExpressions) {
        try {
            LOG.debug("Updating alarm definition {} for tenant {}", (Object)name, (Object)tenantId);
            this.repo.update(tenantId, alarmDefId, patch, name, description, expression, matchBy, severity, enabled, subExpressions.oldAlarmSubExpressions.keySet(), subExpressions.changedSubExpressions, subExpressions.newAlarmSubExpressions, alarmActions, okActions, undeterminedActions);
            String event = Serialization.toJson((Object)new AlarmDefinitionUpdatedEvent(tenantId, alarmDefId, name, description, expression, matchBy, enabled.booleanValue(), severity, subExpressions.oldAlarmSubExpressions, subExpressions.changedSubExpressions, subExpressions.unchangedSubExpressions, subExpressions.newAlarmSubExpressions));
            this.producer.send(new KeyedMessage(this.config.eventsTopic, (Object)String.valueOf(this.eventCount++), (Object)event));
        }
        catch (Exception e) {
            throw Exceptions.uncheck((Exception)e, (String)"Error updating alarm definition for project / tenant %s", (Object[])new Object[]{tenantId});
        }
    }

    SubExpressions subExpressionsFor(Map<String, AlarmSubExpression> initialSubExpressions, AlarmExpression alarmExpression) {
        HashBiMap oldExpressions = HashBiMap.create(initialSubExpressions);
        Set oldSet = oldExpressions.inverse().keySet();
        HashSet newSet = new HashSet(alarmExpression.getSubExpressions());
        HashSet oldOrChangedExpressions = new HashSet(Sets.difference((Set)oldSet, newSet));
        HashSet newOrChangedExpressions = new HashSet(Sets.difference(newSet, (Set)oldSet));
        HashMap<String, AlarmSubExpression> changedExpressions = new HashMap<String, AlarmSubExpression>();
        Iterator oldIt = oldOrChangedExpressions.iterator();
        while (oldIt.hasNext()) {
            AlarmSubExpression oldExpr = (AlarmSubExpression)oldIt.next();
            Iterator newIt = newOrChangedExpressions.iterator();
            while (newIt.hasNext()) {
                AlarmSubExpression newExpr = (AlarmSubExpression)newIt.next();
                if (!this.sameKeyFields(oldExpr, newExpr)) continue;
                oldIt.remove();
                newIt.remove();
                changedExpressions.put((String)oldExpressions.inverse().get((Object)oldExpr), newExpr);
            }
        }
        HashBiMap unchangedExpressions = HashBiMap.create((Map)oldExpressions);
        unchangedExpressions.values().removeAll(oldOrChangedExpressions);
        unchangedExpressions.keySet().removeAll(changedExpressions.keySet());
        oldExpressions.values().retainAll(oldOrChangedExpressions);
        HashMap<String, AlarmSubExpression> newExpressions = new HashMap<String, AlarmSubExpression>();
        for (AlarmSubExpression expression : newOrChangedExpressions) {
            newExpressions.put(UUID.randomUUID().toString(), expression);
        }
        SubExpressions subExpressions = new SubExpressions();
        subExpressions.oldAlarmSubExpressions = oldExpressions;
        subExpressions.changedSubExpressions = changedExpressions;
        subExpressions.unchangedSubExpressions = unchangedExpressions;
        subExpressions.newAlarmSubExpressions = newExpressions;
        return subExpressions;
    }

    private boolean sameKeyFields(AlarmSubExpression a, AlarmSubExpression b) {
        return a.getMetricDefinition().equals((Object)b.getMetricDefinition());
    }

    private AlarmDefinition assertAlarmDefinitionExists(String tenantId, String alarmDefId, List<String> alarmActions, List<String> okActions, List<String> undeterminedActions) {
        AlarmDefinition alarm = this.repo.findById(tenantId, alarmDefId);
        this.assertActionsExist(tenantId, alarmActions, okActions, undeterminedActions);
        return alarm;
    }

    private void assertActionsExist(String tenantId, List<String> alarmActions, List<String> okActions, List<String> undeterminedActions) {
        HashSet<String> actions = new HashSet<String>();
        if (alarmActions != null) {
            actions.addAll(alarmActions);
        }
        if (okActions != null) {
            actions.addAll(okActions);
        }
        if (undeterminedActions != null) {
            actions.addAll(undeterminedActions);
        }
        if (!actions.isEmpty()) {
            for (String action : actions) {
                if (this.notificationMethodRepo.exists(tenantId, action)) continue;
                throw monasca.api.resource.exception.Exceptions.unprocessableEntity("No notification method exists for action %s", action);
            }
        }
    }

    static class SubExpressions {
        Map<String, AlarmSubExpression> oldAlarmSubExpressions;
        Map<String, AlarmSubExpression> changedSubExpressions;
        Map<String, AlarmSubExpression> unchangedSubExpressions;
        Map<String, AlarmSubExpression> newAlarmSubExpressions;

        SubExpressions() {
        }
    }
}

