/*
 * Decompiled with CFR 0.152.
 */
package monasca.api;

import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.PropertyNamingStrategy;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.databind.module.SimpleModule;
import com.google.inject.Module;
import io.dropwizard.Application;
import io.dropwizard.Bundle;
import io.dropwizard.jdbi.bundles.DBIExceptionsBundle;
import io.dropwizard.setup.Bootstrap;
import io.dropwizard.setup.Environment;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import javax.servlet.Filter;
import javax.servlet.FilterRegistration;
import javax.ws.rs.ext.ExceptionMapper;
import monasca.api.ApiConfig;
import monasca.api.MonApiModule;
import monasca.api.infrastructure.servlet.MockAuthenticationFilter;
import monasca.api.infrastructure.servlet.PostAuthenticationFilter;
import monasca.api.infrastructure.servlet.PreAuthenticationFilter;
import monasca.api.infrastructure.servlet.RoleAuthorizationFilter;
import monasca.api.resource.AlarmDefinitionResource;
import monasca.api.resource.AlarmResource;
import monasca.api.resource.DimensionResource;
import monasca.api.resource.MeasurementResource;
import monasca.api.resource.MetricResource;
import monasca.api.resource.NotificationMethodResource;
import monasca.api.resource.NotificationMethodTypesResource;
import monasca.api.resource.StatisticResource;
import monasca.api.resource.VersionResource;
import monasca.api.resource.exception.ConstraintViolationExceptionMapper;
import monasca.api.resource.exception.EntityExistsExceptionMapper;
import monasca.api.resource.exception.EntityNotFoundExceptionMapper;
import monasca.api.resource.exception.IllegalArgumentExceptionMapper;
import monasca.api.resource.exception.InvalidEntityExceptionMapper;
import monasca.api.resource.exception.JsonMappingExceptionManager;
import monasca.api.resource.exception.JsonProcessingExceptionMapper;
import monasca.api.resource.exception.MultipleMetricsExceptionMapper;
import monasca.api.resource.exception.ThrowableExceptionMapper;
import monasca.api.resource.serialization.SubAlarmExpressionSerializer;
import monasca.common.middleware.TokenAuth;
import monasca.common.util.Injector;
import org.eclipse.jetty.servlets.CrossOriginFilter;

public class MonApiApplication
extends Application<ApiConfig> {
    public static void main(String[] args) throws Exception {
        if (args.length == 1 && args[0].toLowerCase().contains("version")) {
            MonApiApplication.showVersion();
            System.exit(0);
        }
        new MonApiApplication().run(args);
    }

    private static void showVersion() {
        Package pkg = Package.getPackage("monasca.api");
        System.out.println("-------- Version Information --------");
        System.out.println(pkg.getImplementationVersion());
    }

    public void initialize(Bootstrap<ApiConfig> bootstrap) {
        bootstrap.addBundle((Bundle)new DBIExceptionsBundle());
    }

    public String getName() {
        return "HP Cloud Monitoring";
    }

    public void run(ApiConfig config, Environment environment) throws Exception {
        Injector.registerModules((Module[])new Module[]{new MonApiModule(environment, config)});
        environment.jersey().register(Injector.getInstance(VersionResource.class));
        environment.jersey().register(Injector.getInstance(AlarmDefinitionResource.class));
        environment.jersey().register(Injector.getInstance(AlarmResource.class));
        environment.jersey().register(Injector.getInstance(DimensionResource.class));
        environment.jersey().register(Injector.getInstance(MetricResource.class));
        environment.jersey().register(Injector.getInstance(MeasurementResource.class));
        environment.jersey().register(Injector.getInstance(StatisticResource.class));
        environment.jersey().register(Injector.getInstance(NotificationMethodResource.class));
        environment.jersey().register(Injector.getInstance(NotificationMethodTypesResource.class));
        this.removeExceptionMappers(environment.jersey().getResourceConfig().getSingletons());
        environment.jersey().register((Object)new EntityExistsExceptionMapper());
        environment.jersey().register((Object)new EntityNotFoundExceptionMapper());
        environment.jersey().register((Object)new IllegalArgumentExceptionMapper());
        environment.jersey().register((Object)new InvalidEntityExceptionMapper());
        environment.jersey().register((Object)new JsonProcessingExceptionMapper());
        environment.jersey().register((Object)new JsonMappingExceptionManager());
        environment.jersey().register((Object)new ConstraintViolationExceptionMapper());
        environment.jersey().register((Object)new ThrowableExceptionMapper<Throwable>(){});
        environment.jersey().register((Object)new MultipleMetricsExceptionMapper());
        environment.getObjectMapper().setPropertyNamingStrategy(PropertyNamingStrategy.CAMEL_CASE_TO_LOWER_CASE_WITH_UNDERSCORES);
        environment.getObjectMapper().enable(DeserializationFeature.ACCEPT_SINGLE_VALUE_AS_ARRAY);
        environment.getObjectMapper().disable(SerializationFeature.WRITE_DATES_AS_TIMESTAMPS);
        environment.getObjectMapper().disable(DeserializationFeature.WRAP_EXCEPTIONS);
        SimpleModule module = new SimpleModule("SerializationModule");
        module.addSerializer((JsonSerializer)new SubAlarmExpressionSerializer());
        environment.getObjectMapper().registerModule((com.fasterxml.jackson.databind.Module)module);
        FilterRegistration.Dynamic corsFilter = environment.servlets().addFilter("cors", CrossOriginFilter.class);
        corsFilter.addMappingForUrlPatterns(null, true, new String[]{"/*"});
        corsFilter.setInitParameter("allowedOrigins", "*");
        corsFilter.setInitParameter("allowedHeaders", "X-Requested-With,Content-Type,Accept,Origin,X-Auth-Token");
        corsFilter.setInitParameter("allowedMethods", "OPTIONS,GET,HEAD");
        if (config.middleware.enabled.booleanValue()) {
            this.ensureHasValue(config.middleware.serverVIP, "serverVIP", "enabled", "true");
            this.ensureHasValue(config.middleware.serverPort, "serverPort", "enabled", "true");
            this.ensureHasValue(config.middleware.adminAuthMethod, "adminAuthMethod", "enabled", "true");
            if ("password".equalsIgnoreCase(config.middleware.adminAuthMethod)) {
                this.ensureHasValue(config.middleware.adminUser, "adminUser", "adminAuthMethod", "password");
                this.ensureHasValue(config.middleware.adminPassword, "adminPassword", "adminAuthMethod", "password");
            } else if ("token".equalsIgnoreCase(config.middleware.adminAuthMethod)) {
                this.ensureHasValue(config.middleware.adminToken, "adminToken", "adminAuthMethod", "token");
            } else {
                throw new Exception(String.format("Invalid value '%s' for adminAuthMethod. Must be either password or token", config.middleware.adminAuthMethod));
            }
            if (config.middleware.defaultAuthorizedRoles == null || config.middleware.defaultAuthorizedRoles.isEmpty()) {
                this.ensureHasValue(null, "defaultAuthorizedRoles", "enabled", "true");
            }
            if (config.middleware.connSSLClientAuth.booleanValue()) {
                this.ensureHasValue(config.middleware.keystore, "keystore", "connSSLClientAuth", "true");
                this.ensureHasValue(config.middleware.keystorePassword, "keystorePassword", "connSSLClientAuth", "true");
            }
            HashMap<String, String> authInitParams = new HashMap<String, String>();
            authInitParams.put("ServerVIP", config.middleware.serverVIP);
            authInitParams.put("ServerPort", config.middleware.serverPort);
            authInitParams.put("UseHttps", String.valueOf(config.middleware.useHttps));
            authInitParams.put("ConnTimeout", config.middleware.connTimeout);
            authInitParams.put("ConnSSLClientAuth", String.valueOf(config.middleware.connSSLClientAuth));
            authInitParams.put("ConnPoolMaxActive", config.middleware.connPoolMaxActive);
            authInitParams.put("ConnPoolMaxIdle", config.middleware.connPoolMaxActive);
            authInitParams.put("ConnPoolEvictPeriod", config.middleware.connPoolEvictPeriod);
            authInitParams.put("ConnPoolMinIdleTime", config.middleware.connPoolMinIdleTime);
            authInitParams.put("ConnRetryTimes", config.middleware.connRetryTimes);
            authInitParams.put("ConnRetryInterval", config.middleware.connRetryInterval);
            authInitParams.put("AdminToken", config.middleware.adminToken);
            authInitParams.put("TimeToCacheToken", config.middleware.timeToCacheToken);
            authInitParams.put("AdminAuthMethod", config.middleware.adminAuthMethod);
            authInitParams.put("AdminUser", config.middleware.adminUser);
            authInitParams.put("AdminPassword", config.middleware.adminPassword);
            authInitParams.put("AdminProjectId", config.middleware.adminProjectId);
            authInitParams.put("AdminProjectName", config.middleware.adminProjectName);
            authInitParams.put("AdminUserDomainId", config.middleware.adminUserDomainId);
            authInitParams.put("AdminUserDomainName", config.middleware.adminUserDomainName);
            authInitParams.put("AdminProjectDomainId", config.middleware.adminProjectDomainId);
            authInitParams.put("AdminProjectDomainName", config.middleware.adminProjectDomainName);
            authInitParams.put("MaxTokenCacheSize", config.middleware.maxTokenCacheSize);
            this.setIfNotNull(authInitParams, "Truststore", config.middleware.truststore);
            this.setIfNotNull(authInitParams, "TruststorePass", config.middleware.truststorePassword);
            this.setIfNotNull(authInitParams, "Keystore", config.middleware.keystore);
            this.setIfNotNull(authInitParams, "KeystorePass", config.middleware.keystorePassword);
            FilterRegistration.Dynamic preAuthenticationFilter = environment.servlets().addFilter("pre-auth", (Filter)new PreAuthenticationFilter());
            preAuthenticationFilter.addMappingForUrlPatterns(null, true, new String[]{"/"});
            preAuthenticationFilter.addMappingForUrlPatterns(null, true, new String[]{"/v2.0/*"});
            FilterRegistration.Dynamic tokenAuthFilter = environment.servlets().addFilter("token-auth", (Filter)new TokenAuth());
            tokenAuthFilter.addMappingForUrlPatterns(null, true, new String[]{"/"});
            tokenAuthFilter.addMappingForUrlPatterns(null, true, new String[]{"/v2.0/*"});
            tokenAuthFilter.setInitParameters(authInitParams);
            FilterRegistration.Dynamic postAuthenticationFilter = environment.servlets().addFilter("post-auth", (Filter)new PostAuthenticationFilter(config.middleware.defaultAuthorizedRoles, config.middleware.agentAuthorizedRoles, config.middleware.readOnlyAuthorizedRoles));
            postAuthenticationFilter.addMappingForUrlPatterns(null, true, new String[]{"/"});
            postAuthenticationFilter.addMappingForUrlPatterns(null, true, new String[]{"/v2.0/*"});
            environment.jersey().getResourceConfig().getContainerRequestFilters().add(new RoleAuthorizationFilter());
        } else {
            FilterRegistration.Dynamic mockAuthenticationFilter = environment.servlets().addFilter("mock-auth", (Filter)new MockAuthenticationFilter());
            mockAuthenticationFilter.addMappingForUrlPatterns(null, true, new String[]{"/"});
            mockAuthenticationFilter.addMappingForUrlPatterns(null, true, new String[]{"/v2.0/*"});
        }
    }

    private void ensureHasValue(String value, String what, String control, String controlValue) throws Exception {
        if (value == null || value.isEmpty()) {
            String message = String.format("Since %s in middleware section of configuration file is set to %s, %s must have a value", control, controlValue, what);
            throw new Exception(message);
        }
    }

    private void setIfNotNull(Map<String, String> authInitParams, String name, String value) {
        if (value != null) {
            authInitParams.put(name, value);
        }
    }

    private void removeExceptionMappers(Set<Object> items) {
        Iterator<Object> i = items.iterator();
        while (i.hasNext()) {
            Object o = i.next();
            if (!(o instanceof ExceptionMapper)) continue;
            i.remove();
        }
    }
}

