/*
 * Decompiled with CFR 0.152.
 */
package monasca.api.resource;

import com.codahale.metrics.annotation.Timed;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.util.Arrays;
import java.util.List;
import javax.inject.Inject;
import javax.validation.Valid;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.HeaderParam;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;
import monasca.api.ApiConfig;
import monasca.api.app.command.CreateNotificationMethodCommand;
import monasca.api.app.command.PatchNotificationMethodCommand;
import monasca.api.app.command.UpdateNotificationMethodCommand;
import monasca.api.app.validation.NotificationMethodValidation;
import monasca.api.app.validation.Validation;
import monasca.api.domain.model.notificationmethod.NotificationMethod;
import monasca.api.domain.model.notificationmethod.NotificationMethodRepo;
import monasca.api.infrastructure.persistence.PersistUtils;
import monasca.api.resource.Links;
import monasca.api.resource.annotation.PATCH;

@Path(value="/v2.0/notification-methods")
public class NotificationMethodResource {
    private final NotificationMethodRepo repo;
    private final PersistUtils persistUtils;
    private static final List<String> ALLOWED_SORT_BY = Arrays.asList("id", "name", "type", "address", "updated_at", "created_at");
    private final List<Integer> validPeriods;

    @Inject
    public NotificationMethodResource(ApiConfig config, NotificationMethodRepo repo, PersistUtils persistUtils) {
        this.repo = repo;
        this.persistUtils = persistUtils;
        this.validPeriods = config.validNotificationPeriods == null ? Arrays.asList(0, 60) : config.validNotificationPeriods;
    }

    @POST
    @Timed
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public Response create(@Context UriInfo uriInfo, @HeaderParam(value="X-Tenant-Id") String tenantId, @Valid CreateNotificationMethodCommand command) {
        command.validate(this.validPeriods);
        NotificationMethod notificationMethod = Links.hydrate(this.repo.create(tenantId, command.name, command.type, command.address, command.getConvertedPeriod()), uriInfo, false, new String[0]);
        return Response.created((URI)URI.create(notificationMethod.getId())).entity((Object)notificationMethod).build();
    }

    @GET
    @Timed
    @Produces(value={"application/json"})
    public Object list(@Context UriInfo uriInfo, @HeaderParam(value="X-Tenant-Id") String tenantId, @QueryParam(value="sort_by") String sortByStr, @QueryParam(value="offset") String offset, @QueryParam(value="limit") String limit) throws UnsupportedEncodingException {
        List<String> sortByList = Validation.parseAndValidateSortBy(sortByStr, ALLOWED_SORT_BY);
        int paging_limit = this.persistUtils.getLimit(limit);
        List<NotificationMethod> resources = this.repo.find(tenantId, sortByList, offset, paging_limit);
        return Links.paginate(paging_limit, Links.hydrate(resources, uriInfo, new String[0]), uriInfo);
    }

    @GET
    @Timed
    @Path(value="/{notification_method_id}")
    @Produces(value={"application/json"})
    public NotificationMethod get(@Context UriInfo uriInfo, @HeaderParam(value="X-Tenant-Id") String tenantId, @PathParam(value="notification_method_id") String notificationMethodId) {
        return Links.hydrate(this.repo.findById(tenantId, notificationMethodId), uriInfo, true, new String[0]);
    }

    @PUT
    @Timed
    @Path(value="/{notification_method_id}")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public NotificationMethod update(@Context UriInfo uriInfo, @HeaderParam(value="X-Tenant-Id") String tenantId, @PathParam(value="notification_method_id") String notificationMethodId, @Valid UpdateNotificationMethodCommand command) {
        command.validate(this.validPeriods);
        return Links.hydrate(this.repo.update(tenantId, notificationMethodId, command.name, command.type, command.address, command.getConvertedPeriod()), uriInfo, true, new String[0]);
    }

    @PATCH
    @Timed
    @Path(value="/{notification_method_id}")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public NotificationMethod patch(@Context UriInfo uriInfo, @HeaderParam(value="X-Tenant-Id") String tenantId, @PathParam(value="notification_method_id") String notificationMethodId, @Valid PatchNotificationMethodCommand command) {
        NotificationMethod originalNotificationMethod = this.repo.findById(tenantId, notificationMethodId);
        String name = command.name == null ? originalNotificationMethod.getName() : command.name;
        String type = command.type == null ? originalNotificationMethod.getType() : command.type;
        String address = command.address == null ? originalNotificationMethod.getAddress() : command.address;
        int period = command.period == null ? originalNotificationMethod.getPeriod() : command.getConvertedPeriod();
        NotificationMethodValidation.validate(type, address, period, this.validPeriods);
        return Links.hydrate(this.repo.update(tenantId, notificationMethodId, name, type, address, period), uriInfo, true, new String[0]);
    }

    @DELETE
    @Timed
    @Path(value="/{notification_method_id}")
    public void delete(@HeaderParam(value="X-Tenant-Id") String tenantId, @PathParam(value="notification_method_id") String notificationMethodId) {
        this.repo.deleteById(tenantId, notificationMethodId);
    }
}

