/*
 * Decompiled with CFR 0.152.
 */
package monasca.api.resource;

import com.google.common.base.Preconditions;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.List;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.UriInfo;
import monasca.api.ApiConfig;
import monasca.api.domain.model.alarm.AlarmCount;
import monasca.api.domain.model.common.Link;
import monasca.api.domain.model.common.Linked;
import monasca.api.domain.model.common.Paged;
import monasca.api.domain.model.dimension.DimensionValues;
import monasca.api.domain.model.measurement.Measurements;
import monasca.common.model.domain.common.AbstractEntity;
import monasca.common.util.Injector;

public final class Links {
    static boolean accessedViaHttps;

    public static <T extends AbstractEntity> List<T> hydrate(List<T> resources, UriInfo uriInfo, String ... children) {
        Preconditions.checkNotNull(resources, (Object)"resources");
        String absolutePath = Links.prefixForHttps(uriInfo.getAbsolutePath().toString());
        for (AbstractEntity resource : resources) {
            Links.hydrate(resource, absolutePath, false, children);
        }
        return resources;
    }

    public static <T extends AbstractEntity> T hydrate(T resource, UriInfo uriInfo) {
        return Links.hydrate(resource, Links.prefixForHttps(uriInfo.getAbsolutePath().toString()), false, new String[0]);
    }

    public static <T extends AbstractEntity> T hydrate(T resource, UriInfo uriInfo, String resourcePath) {
        return Links.hydrate(resource, Links.concatPaths(uriInfo.getBaseUri().toString(), resourcePath) + "/", false, new String[0]);
    }

    private static String concatPaths(String first, String second) {
        if ((first.isEmpty() || first.endsWith("/")) && !second.isEmpty() && second.startsWith("/")) {
            return first + second.substring(1);
        }
        return first + second;
    }

    public static <T extends AbstractEntity> T hydrate(T resource, UriInfo uriInfo, boolean uriInfoForSpecificResource, String ... children) {
        return Links.hydrate(resource, Links.prefixForHttps(uriInfo.getAbsolutePath().toString()), uriInfoForSpecificResource, children);
    }

    static String prefixForHttps(String path) {
        if (accessedViaHttps && !path.toLowerCase().startsWith("https")) {
            path = "https" + path.substring(path.indexOf("://"));
        }
        return path;
    }

    private static <T extends AbstractEntity> T hydrate(T resource, String path, boolean pathForSpecificResource, String ... children) {
        Preconditions.checkNotNull(resource, (Object)"resource");
        ArrayList<Link> links = new ArrayList<Link>(children.length + 1);
        if (!pathForSpecificResource) {
            boolean pathEndsInSlash;
            boolean bl = pathEndsInSlash = path.length() > 0 && path.charAt(path.length() - 1) == '/';
            if (!pathEndsInSlash) {
                path = path + "/";
            }
            path = path + resource.getId();
        }
        links.add(new Link("self", path));
        for (String child : children) {
            links.add(new Link(child, path + "/" + child));
        }
        ((Linked)resource).setLinks(links);
        return resource;
    }

    public static Paged paginate(int limit, List<? extends AbstractEntity> elements, UriInfo uriInfo) throws UnsupportedEncodingException {
        if (limit == 0) {
            Paged paged = new Paged();
            paged.elements = elements != null ? elements : new ArrayList();
            return paged;
        }
        Paged paged = new Paged();
        paged.links.add(Links.getSelfLink(uriInfo));
        if (elements != null) {
            if (elements.size() > limit) {
                String offset = ((AbstractEntity)elements.get(limit - 1)).getId();
                paged.links.add(Links.getNextLink(offset, uriInfo));
                elements = elements.subList(0, limit);
            }
            paged.elements = elements;
        } else {
            paged.elements = new ArrayList();
        }
        return paged;
    }

    public static Object paginateAlarming(int limit, List<? extends AbstractEntity> elements, UriInfo uriInfo) throws UnsupportedEncodingException {
        if (limit == 0) {
            Paged paged = new Paged();
            paged.elements = elements != null ? elements : new ArrayList();
            return paged;
        }
        Paged paged = new Paged();
        paged.links.add(Links.getSelfLink(uriInfo));
        if (elements != null) {
            if (elements.size() > limit) {
                MultivaluedMap queryParams = uriInfo.getQueryParameters();
                int offset = 0;
                if (queryParams.containsKey((Object)"offset")) {
                    offset = Integer.parseInt((String)((List)queryParams.get((Object)"offset")).get(0));
                }
                String nextOffset = String.valueOf(limit + offset);
                paged.links.add(Links.getNextLink(nextOffset, uriInfo));
                elements = elements.subList(0, limit);
            }
            paged.elements = elements;
        } else {
            paged.elements = new ArrayList();
        }
        return paged;
    }

    public static Object paginateMeasurements(int limit, List<? extends Measurements> elements, UriInfo uriInfo) throws UnsupportedEncodingException {
        if (limit == 0) {
            Paged paged = new Paged();
            paged.elements = elements != null ? elements : new ArrayList();
            return paged;
        }
        Paged paged = new Paged();
        paged.links.add(Links.getSelfLink(uriInfo));
        if (elements != null && !elements.isEmpty()) {
            int remaining_limit = limit;
            for (int i = 0; i < elements.size(); ++i) {
                Measurements s = (Measurements)((Object)elements.get(i));
                if (s != null) {
                    List<List<Object>> l = s.getMeasurements();
                    if (l.size() >= remaining_limit) {
                        String offset = s.getId();
                        offset = offset != null ? offset + '_' + (String)l.get(remaining_limit - 1).get(0) : (String)l.get(remaining_limit - 1).get(0);
                        paged.links.add(Links.getNextLink(offset, uriInfo));
                        l = l.subList(0, remaining_limit);
                        s.setMeasurements(l);
                        elements = elements.subList(0, i + 1);
                    } else {
                        remaining_limit -= l.size();
                    }
                    paged.elements = elements;
                    continue;
                }
                paged.elements = new ArrayList();
            }
        } else {
            paged.elements = new ArrayList();
        }
        return paged;
    }

    private static Link getSelfLink(UriInfo uriInfo) {
        Link selfLink = new Link();
        selfLink.rel = "self";
        selfLink.href = Links.prefixForHttps(uriInfo.getRequestUri().toString());
        return selfLink;
    }

    private static Link getNextLink(String offset, UriInfo uriInfo) throws UnsupportedEncodingException {
        Link nextLink = new Link();
        nextLink.rel = "next";
        nextLink.href = Links.prefixForHttps(uriInfo.getAbsolutePath().toString() + "?offset=" + URLEncoder.encode(offset, "UTF-8"));
        for (String parmKey : uriInfo.getQueryParameters().keySet()) {
            if (parmKey.equalsIgnoreCase("offset")) continue;
            List parmValList = (List)uriInfo.getQueryParameters().get((Object)parmKey);
            for (String parmVal : parmValList) {
                nextLink.href = nextLink.href + "&" + URLEncoder.encode(parmKey, "UTF-8") + "=" + URLEncoder.encode(parmVal, "UTF-8");
            }
        }
        return nextLink;
    }

    public static void paginateAlarmCount(AlarmCount alarmCount, int limit, UriInfo uriInfo) throws UnsupportedEncodingException {
        ArrayList<Link> links = new ArrayList<Link>();
        links.add(Links.getSelfLink(uriInfo));
        if (alarmCount.getCounts().size() > limit) {
            alarmCount.getCounts().remove(alarmCount.getCounts().size() - 1);
            String offset = String.valueOf(limit);
            links.add(Links.getNextLink(offset, uriInfo));
        }
        alarmCount.setLinks(links);
    }

    public static Paged paginateDimensionValues(DimensionValues dimVals, int limit, UriInfo uriInfo) throws UnsupportedEncodingException {
        Paged paged = new Paged();
        ArrayList elements = new ArrayList();
        paged.links.add(Links.getSelfLink(uriInfo));
        if (null != dimVals && dimVals.getValues().size() > limit) {
            dimVals.getValues().remove(dimVals.getValues().size() - 1);
            String offset = dimVals.getValues().get(dimVals.getValues().size() - 1);
            paged.links.add(Links.getNextLink(offset, uriInfo));
        }
        elements.add(dimVals);
        paged.elements = elements;
        return paged;
    }

    static {
        ApiConfig config = (ApiConfig)((Object)Injector.getInstance(ApiConfig.class));
        if (config != null && config.accessedViaHttps != null) {
            accessedViaHttps = config.accessedViaHttps;
        }
    }
}

