/*
 * Decompiled with CFR 0.152.
 */
package monasca.api.resource;

import com.codahale.metrics.annotation.Timed;
import javax.inject.Inject;
import javax.ws.rs.GET;
import javax.ws.rs.HeaderParam;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.UriInfo;
import monasca.api.ApiConfig;
import monasca.api.app.validation.Validation;
import monasca.api.domain.model.dimension.DimensionRepo;
import monasca.api.domain.model.dimension.DimensionValues;
import monasca.api.infrastructure.persistence.PersistUtils;
import monasca.api.resource.Links;

@Path(value="/v2.0/metrics/dimensions/names/values")
public class DimensionResource {
    private final DimensionRepo repo;
    private final PersistUtils persistUtils;
    private final String admin_role;

    @Inject
    public DimensionResource(ApiConfig config, DimensionRepo repo, PersistUtils persistUtils) {
        this.admin_role = config.middleware == null || config.middleware.adminRole == null ? "monasca-admin" : config.middleware.adminRole;
        this.repo = repo;
        this.persistUtils = persistUtils;
    }

    @GET
    @Timed
    @Produces(value={"application/json"})
    public Object get(@Context UriInfo uriInfo, @HeaderParam(value="X-Tenant-Id") String tenantId, @HeaderParam(value="X-Roles") String roles, @QueryParam(value="limit") String limit, @QueryParam(value="dimension_name") String dimensionName, @QueryParam(value="metric_name") String metricName, @QueryParam(value="offset") String offset, @QueryParam(value="tenant_id") String crossTenantId) throws Exception {
        Validation.validateNotNullOrEmpty(dimensionName, "dimension_name");
        int paging_limit = this.persistUtils.getLimit(limit);
        String queryTenantId = Validation.getQueryProject(roles, crossTenantId, tenantId, this.admin_role);
        DimensionValues dimVals = this.repo.find(metricName, queryTenantId, dimensionName, offset, paging_limit);
        return Links.paginateDimensionValues(dimVals, paging_limit, uriInfo);
    }
}

