/*
 * Decompiled with CFR 0.152.
 */
package monasca.api.infrastructure.persistence.vertica;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import javax.inject.Inject;
import javax.inject.Named;
import monasca.api.ApiConfig;
import monasca.api.domain.exception.MultipleMetricsException;
import monasca.api.domain.model.measurement.MeasurementRepo;
import monasca.api.domain.model.measurement.Measurements;
import monasca.api.infrastructure.persistence.vertica.MetricQueries;
import org.joda.time.DateTime;
import org.joda.time.format.DateTimeFormatter;
import org.joda.time.format.ISODateTimeFormat;
import org.skife.jdbi.v2.DBI;
import org.skife.jdbi.v2.Handle;
import org.skife.jdbi.v2.Query;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MeasurementVerticaRepoImpl
implements MeasurementRepo {
    private static final Logger logger = LoggerFactory.getLogger(MeasurementVerticaRepoImpl.class);
    public static final DateTimeFormatter DATETIME_FORMATTER = ISODateTimeFormat.dateTime().withZoneUTC();
    private static final String FIND_BY_METRIC_DEF_SQL = "SELECT %s to_hex(mes.definition_dimensions_id) as def_dims_id, mes.time_stamp, mes.value, mes.value_meta FROM MonMetrics.Measurements mes WHERE mes.time_stamp >= :startTime %s AND TO_HEX(definition_dimensions_id) IN (%s) ORDER BY %smes.time_stamp ASC LIMIT :limit";
    private final DBI db;
    private final ObjectMapper objectMapper = new ObjectMapper();
    private static final TypeReference VALUE_META_TYPE = new TypeReference<Map<String, String>>(){};
    private final String dbHint;

    @Inject
    public MeasurementVerticaRepoImpl(@Named(value="vertica") DBI db, ApiConfig config) {
        this.db = db;
        this.dbHint = config.vertica.dbHint;
    }

    @Override
    public List<Measurements> find(String tenantId, String name, Map<String, String> dimensions, DateTime startTime, @Nullable DateTime endTime, @Nullable String offset, int limit, Boolean mergeMetricsFlag, String groupBy) throws MultipleMetricsException {
        try (Handle h = this.db.open();){
            List rows;
            HashMap<String, Measurements> results = new HashMap<String, Measurements>();
            if (!"*".equals(groupBy) && !Boolean.TRUE.equals(mergeMetricsFlag)) {
                MetricQueries.checkForMultipleDefinitions(h, tenantId, name, dimensions);
            }
            StringBuilder sb = new StringBuilder();
            if (endTime != null) {
                sb.append(" and mes.time_stamp <= :endTime");
            }
            if (offset != null && !offset.isEmpty()) {
                if ("*".equals(groupBy)) {
                    sb.append(" and (TO_HEX(mes.definition_dimensions_id) > :offset_id or (TO_HEX(mes.definition_dimensions_id) = :offset_id and mes.time_stamp > :offset_timestamp)) ");
                } else {
                    sb.append(" and mes.time_stamp > :offset_timestamp ");
                }
            }
            String orderById = "";
            if (Boolean.FALSE.equals(mergeMetricsFlag)) {
                orderById = "mes.definition_dimensions_id,";
            }
            String sql = String.format(FIND_BY_METRIC_DEF_SQL, this.dbHint, sb, MetricQueries.buildMetricDefinitionSubSql(name, dimensions, null, null), orderById);
            Query query = (Query)((Query)((Query)h.createQuery(sql).bind("tenantId", tenantId)).bind("startTime", new Timestamp(startTime.getMillis()))).bind("limit", limit + 1);
            if (name != null && !name.isEmpty()) {
                query.bind("name", name);
            }
            MetricQueries.bindDimensionsToQuery(query, dimensions);
            if (endTime != null) {
                logger.debug("binding endtime: {}", (Object)endTime);
                query.bind("endTime", new Timestamp(endTime.getMillis()));
            }
            if (offset != null && !offset.isEmpty()) {
                logger.debug("binding offset: {}", (Object)offset);
                MetricQueries.bindOffsetToQuery((Query<Map<String, Object>>)query, offset);
            }
            if ((rows = query.list()).size() == 0) {
                ArrayList<Measurements> arrayList = new ArrayList<Measurements>();
                return arrayList;
            }
            if ("*".equals(groupBy)) {
                String currentDefId = null;
                for (Map row : rows) {
                    String defDimsId = (String)row.get("def_dims_id");
                    if (defDimsId != null && !defDimsId.equals(currentDefId)) {
                        currentDefId = defDimsId;
                        results.put(defDimsId, new Measurements());
                    }
                    List<Object> measurement = this.parseRow(row);
                    ((Measurements)((Object)results.get(defDimsId))).addMeasurement(measurement);
                }
                MetricQueries.addDefsToResults(results, h, this.dbHint);
            } else {
                Measurements firstMeasurement = new Measurements();
                firstMeasurement.setName(name);
                String firstDefDimsId = (String)((Map)rows.get(0)).get("def_dims_id");
                for (Map row : rows) {
                    List<Object> measurement = this.parseRow(row);
                    firstMeasurement.addMeasurement(measurement);
                }
                results.put(firstDefDimsId, firstMeasurement);
                if (!Boolean.TRUE.equals(mergeMetricsFlag)) {
                    firstMeasurement.setId(firstDefDimsId);
                    MetricQueries.addDefsToResults(results, h, this.dbHint);
                } else {
                    if (dimensions == null) {
                        dimensions = new HashMap<String, String>();
                    }
                    firstMeasurement.setDimensions(dimensions);
                }
            }
            ArrayList<Measurements> arrayList = new ArrayList<Measurements>(results.values());
            return arrayList;
        }
    }

    private List<Object> parseRow(Map<String, Object> row) {
        String timestamp = DATETIME_FORMATTER.print(((Timestamp)row.get("time_stamp")).getTime());
        double value = (Double)row.get("value");
        String valueMetaString = (String)row.get("value_meta");
        Map valueMetaMap = new HashMap();
        if (valueMetaString != null && !valueMetaString.isEmpty()) {
            try {
                valueMetaMap = (Map)this.objectMapper.readValue(valueMetaString, VALUE_META_TYPE);
            }
            catch (IOException e) {
                logger.error("failed to parse value metadata: {}", (Object)valueMetaString);
            }
        }
        return Arrays.asList(timestamp, value, valueMetaMap);
    }
}

