/*
 * Decompiled with CFR 0.152.
 */
package monasca.api.infrastructure.persistence.vertica;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.inject.Inject;
import javax.inject.Named;
import monasca.api.ApiConfig;
import monasca.api.domain.model.dimension.DimensionRepo;
import monasca.api.domain.model.dimension.DimensionValues;
import org.skife.jdbi.v2.DBI;
import org.skife.jdbi.v2.Handle;
import org.skife.jdbi.v2.Query;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DimensionVerticaRepoImpl
implements DimensionRepo {
    private static final Logger logger = LoggerFactory.getLogger(DimensionVerticaRepoImpl.class);
    private static final String FIND_DIMENSION_VALUES_SQL = "SELECT %s  DISTINCT dims.value as dValue FROM   MonMetrics.Definitions def,  MonMetrics.DefinitionDimensions defdims LEFT OUTER JOIN  MonMetrics.Dimensions dims    ON dims.dimension_set_id = defdims.dimension_set_id WHERE  def.id = defdims.definition_id  %s   %s   and def.tenant_id = '%s'  and dims.name = '%s' ORDER BY dims.value ASC %s ";
    private final DBI db;
    private final String dbHint;

    @Inject
    public DimensionVerticaRepoImpl(@Named(value="vertica") DBI db, ApiConfig config) {
        this.db = db;
        this.dbHint = config.vertica.dbHint;
    }

    @Override
    public DimensionValues find(String metricName, String tenantId, String dimensionName, String offset, int limit) throws Exception {
        ArrayList<String> values = new ArrayList<String>();
        String offsetPart = "";
        String metricNamePart = "";
        try (Handle h = this.db.open();){
            if (offset != null && !offset.isEmpty()) {
                offsetPart = " and dims.value > '" + offset + "' ";
            }
            if (metricName != null && !metricName.isEmpty()) {
                metricNamePart = " and def.name = '" + metricName + "' ";
            }
            String limitPart = " limit " + Integer.toString(limit + 1);
            String sql = String.format(FIND_DIMENSION_VALUES_SQL, this.dbHint, offsetPart, metricNamePart, tenantId, dimensionName, limitPart);
            Query query = h.createQuery(sql);
            List rows = query.list();
            for (Map row : rows) {
                String dimValue = (String)row.get("dValue");
                values.add(dimValue);
            }
        }
        return new DimensionValues(metricName, dimensionName, values);
    }
}

