/*
 * Decompiled with CFR 0.152.
 */
package monasca.api.infrastructure.persistence.mysql;

import com.google.common.base.Joiner;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import javax.inject.Inject;
import javax.inject.Named;
import monasca.api.domain.exception.EntityExistsException;
import monasca.api.domain.exception.EntityNotFoundException;
import monasca.api.domain.model.notificationmethod.NotificationMethod;
import monasca.api.domain.model.notificationmethod.NotificationMethodRepo;
import monasca.api.infrastructure.persistence.PersistUtils;
import monasca.common.persistence.BeanMapper;
import org.skife.jdbi.v2.DBI;
import org.skife.jdbi.v2.Handle;
import org.skife.jdbi.v2.Query;
import org.skife.jdbi.v2.tweak.ResultSetMapper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NotificationMethodMySqlRepoImpl
implements NotificationMethodRepo {
    private static final Logger LOG = LoggerFactory.getLogger(NotificationMethodMySqlRepoImpl.class);
    private static final Joiner COMMA_JOINER = Joiner.on((char)',');
    private final DBI db;
    private final PersistUtils persistUtils;

    @Inject
    public NotificationMethodMySqlRepoImpl(@Named(value="mysql") DBI db, PersistUtils persistUtils) {
        this.db = db;
        this.persistUtils = persistUtils;
    }

    @Override
    public NotificationMethod create(String tenantId, String name, String notificationMethodType, String address, int period) {
        try (Handle h = this.db.open();){
            h.begin();
            if (this.getNotificationIdForTenantIdAndName(h, tenantId, name) != null) {
                throw new EntityExistsException("Notification method %s \"%s\" already exists.", tenantId, name);
            }
            if (!this.isValidNotificationMethodType(h, notificationMethodType)) {
                throw new EntityNotFoundException("Not a valid notification method type %s ", notificationMethodType);
            }
            String id = UUID.randomUUID().toString();
            h.insert("insert into notification_method (id, tenant_id, name, type, address, period, created_at, updated_at) values (?, ?, ?, ?, ?, ?, NOW(), NOW())", new Object[]{id, tenantId, name, notificationMethodType, address, period});
            LOG.debug("Creating notification method {} for {}", (Object)name, (Object)tenantId);
            h.commit();
            NotificationMethod notificationMethod = new NotificationMethod(id, name, notificationMethodType, address, period);
            return notificationMethod;
        }
    }

    @Override
    public void deleteById(String tenantId, String notificationMethodId) {
        try (Handle h = this.db.open();){
            if (h.update("delete from notification_method where tenant_id = ? and id = ?", new Object[]{tenantId, notificationMethodId}) == 0) {
                throw new EntityNotFoundException("No notification method exists for %s", notificationMethodId);
            }
        }
    }

    @Override
    public boolean exists(String tenantId, String notificationMethodId) {
        try (Handle h = this.db.open();){
            boolean bl = (Boolean)((Query)((Query)h.createQuery("select exists(select 1 from notification_method where tenant_id = :tenantId and id = :notificationMethodId)").bind("tenantId", tenantId)).bind("notificationMethodId", notificationMethodId)).mapTo(Boolean.TYPE).first();
            return bl;
        }
    }

    private String getNotificationIdForTenantIdAndName(Handle h, String tenantId, String name) {
        Map map = (Map)((Query)((Query)h.createQuery("select id from notification_method where tenant_id = :tenantId and name = :name").bind("tenantId", tenantId)).bind("name", name)).first();
        if (map != null && !map.isEmpty()) {
            return map.get("id").toString();
        }
        return null;
    }

    private boolean isValidNotificationMethodType(Handle h, String notificationMethod) {
        String query = "  SELECT name from notification_method_type";
        Query q = h.createQuery(query);
        List result = q.list();
        for (Map m : result) {
            String method = (String)m.get("name");
            if (!method.equalsIgnoreCase(notificationMethod)) continue;
            return true;
        }
        return false;
    }

    @Override
    public List<NotificationMethod> find(String tenantId, List<String> sortBy, String offset, int limit) {
        try (Handle h = this.db.open();){
            String rawQuery = "  SELECT nm.id, nm.tenant_id, nm.name, nm.type, nm.address, nm.period, nm.created_at, nm.updated_at FROM notification_method as nm WHERE tenant_id = :tenantId %1$s %2$s %3$s";
            String offsetPart = "";
            if (offset != null) {
                offsetPart = "and nm.id > :offset";
            }
            String orderByPart = "";
            if (sortBy != null && !sortBy.isEmpty()) {
                orderByPart = " order by " + COMMA_JOINER.join(sortBy);
                if (!orderByPart.contains("id")) {
                    orderByPart = orderByPart + ",id";
                }
            } else {
                orderByPart = " order by id ";
            }
            String limitPart = "";
            if (limit > 0) {
                limitPart = " limit :limit";
            }
            String query = String.format(rawQuery, offsetPart, orderByPart, limitPart);
            Query q = h.createQuery(query);
            q.bind("tenantId", tenantId);
            if (offset != null) {
                q.bind("offset", offset);
            }
            if (limit > 0) {
                q.bind("limit", limit + 1);
            }
            List list = q.map((ResultSetMapper)new BeanMapper(NotificationMethod.class)).list();
            return list;
        }
    }

    @Override
    public NotificationMethod findById(String tenantId, String notificationMethodId) {
        try (Handle h = this.db.open();){
            NotificationMethod notificationMethod = (NotificationMethod)((Query)((Query)h.createQuery("select * from notification_method where tenant_id = :tenantId and id = :id").bind("tenantId", tenantId)).bind("id", notificationMethodId)).map((ResultSetMapper)new BeanMapper(NotificationMethod.class)).first();
            if (notificationMethod == null) {
                throw new EntityNotFoundException("No notification method exists for %s", notificationMethodId);
            }
            NotificationMethod notificationMethod2 = notificationMethod;
            return notificationMethod2;
        }
    }

    @Override
    public NotificationMethod update(String tenantId, String notificationMethodId, String name, String notificationMethodType, String address, int period) {
        try (Handle h = this.db.open();){
            h.begin();
            String notificationID = this.getNotificationIdForTenantIdAndName(h, tenantId, name);
            if (notificationID != null && !notificationID.equalsIgnoreCase(notificationMethodId)) {
                throw new EntityExistsException("Notification method %s \"%s\" already exists.", tenantId, name);
            }
            if (!this.isValidNotificationMethodType(h, notificationMethodType)) {
                throw new EntityNotFoundException("Not a valid notification method type %s ", notificationMethodType);
            }
            if (h.update("update notification_method set name = ?, type = ?, address = ?, period = ?, updated_at = NOW() where tenant_id = ? and id = ?", new Object[]{name, notificationMethodType, address, period, tenantId, notificationMethodId}) == 0) {
                throw new EntityNotFoundException("No notification method exists for %s", notificationMethodId);
            }
            h.commit();
            NotificationMethod notificationMethod = new NotificationMethod(notificationMethodId, name, notificationMethodType, address, period);
            return notificationMethod;
        }
    }
}

