/*
 * Decompiled with CFR 0.152.
 */
package monasca.api.infrastructure.persistence.influxdb;

import com.google.common.base.Splitter;
import com.google.common.base.Strings;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import monasca.common.util.Conversions;
import org.apache.commons.lang3.StringUtils;
import org.joda.time.DateTime;
import org.joda.time.ReadableInstant;
import org.joda.time.format.ISODateTimeFormat;

public class InfluxV9Utils {
    private static final Pattern sqlUnsafePattern = Pattern.compile("^.*('|;|\")+.*$");
    static final String OFFSET_SEPARATOR = "_";
    static final Splitter offsetSplitter = Splitter.on((String)"_").omitEmptyStrings().trimResults();

    public String sanitize(String taintedString) {
        Matcher m = sqlUnsafePattern.matcher(taintedString);
        if (m.matches()) {
            throw new IllegalArgumentException(String.format("Input from user contains single quote ['] or semi-colon [;] or double quote [\"] characters[ %1$s ]", taintedString));
        }
        return taintedString;
    }

    String buildTimePart(DateTime startTime, DateTime endTime) {
        StringBuilder sb = new StringBuilder();
        if (startTime != null) {
            sb.append(String.format(" and time >= '" + ISODateTimeFormat.dateTime().print((ReadableInstant)startTime) + "'", new Object[0]));
        }
        if (endTime != null) {
            sb.append(String.format(" and time <= '" + ISODateTimeFormat.dateTime().print((ReadableInstant)endTime) + "'", new Object[0]));
        }
        return sb.toString();
    }

    public String buildAlarmsPart(List<String> alarmIds) {
        StringBuilder sb = new StringBuilder();
        for (String alarmId : alarmIds) {
            if (sb.length() > 0) {
                sb.append(" or ");
            }
            sb.append(String.format(" alarm_id = '%1$s' ", alarmId));
        }
        if (sb.length() > 0) {
            sb.insert(0, " and (");
            sb.insert(sb.length(), ")");
        }
        return sb.toString();
    }

    public String groupByPart() {
        return " group by *";
    }

    public String namePart(String name, boolean isRequired) {
        if (isRequired && (name == null || name.isEmpty())) {
            throw new IllegalArgumentException(String.format("Found null or empty name: %1$s", name));
        }
        if (name == null || name.isEmpty()) {
            return "";
        }
        return String.format(" from \"%1$s\"", this.sanitize(name));
    }

    public String publicTenantIdPart(String tenantId) {
        if (tenantId == null || tenantId.isEmpty()) {
            throw new IllegalArgumentException(String.format("Found null or empty tenant id: %1$s", tenantId));
        }
        return " tenant_id='" + this.sanitize(tenantId) + "'";
    }

    public String privateTenantIdPart(String tenantId) {
        if (tenantId == null || tenantId.isEmpty()) {
            throw new IllegalArgumentException(String.format("Found null or empty tenant id: %1$s", tenantId));
        }
        return " _tenant_id='" + this.sanitize(tenantId) + "'";
    }

    public String alarmIdPart(String alarmId) {
        if (alarmId == null || alarmId.isEmpty()) {
            return "";
        }
        return " and alarm_id='" + alarmId + "'";
    }

    public String timeOffsetPart(String offset) {
        if (StringUtils.isEmpty((CharSequence)offset)) {
            return "";
        }
        if (!"0".equals(offset)) {
            Object convertible;
            try {
                convertible = Long.valueOf(offset);
            }
            catch (IllegalArgumentException exp) {
                convertible = offset;
            }
            offset = Conversions.variantToDateTime((Object)convertible).toString(ISODateTimeFormat.dateTime());
        }
        return String.format(" and time > '%1$s'", offset);
    }

    public String privateRegionPart(String region) {
        if (region == null || region.isEmpty()) {
            throw new IllegalArgumentException(String.format("Found null or empty region: %1$s", region));
        }
        return " and _region='" + this.sanitize(region) + "'";
    }

    public String dimPart(Map<String, String> dims) {
        StringBuilder sb = new StringBuilder();
        if (dims != null && !dims.isEmpty()) {
            for (String k : dims.keySet()) {
                String v = dims.get(k);
                if (k == null || k.isEmpty()) continue;
                sb.append(" and \"" + this.sanitize(k) + "\"");
                if (Strings.isNullOrEmpty((String)v)) {
                    sb.append("=~ /.*/");
                    continue;
                }
                if (v.contains("|")) {
                    sb.append("=~ /^" + this.sanitize(v) + "$/");
                    continue;
                }
                sb.append("= '" + this.sanitize(v) + "'");
            }
        }
        return sb.toString();
    }

    public String startTimePart(DateTime startTime) {
        return startTime != null ? " and time > '" + ISODateTimeFormat.dateTime().print((ReadableInstant)startTime) + "'" : "";
    }

    public String endTimePart(DateTime endTime) {
        return endTime != null ? " and time < '" + ISODateTimeFormat.dateTime().print((ReadableInstant)endTime) + "'" : "";
    }

    public String limitPart(int limit) {
        return String.format(" limit %1$d", limit + 1);
    }

    public String offsetPart(int startIndex) {
        return String.format(" offset %1$d", startIndex);
    }

    public int startIndex(String offset) {
        int intOffset;
        if (offset == null || offset.isEmpty()) {
            return 0;
        }
        try {
            intOffset = Integer.parseInt(offset);
        }
        catch (NumberFormatException nfe) {
            throw new IllegalArgumentException(String.format("Found non-integer offset '%1$s'. Offset must be a positive integer", offset));
        }
        if (intOffset < 0) {
            throw new IllegalArgumentException(String.format("Found negative offset '%1$s'. Offset must be a positive integer", offset));
        }
        return intOffset + 1;
    }

    public String startTimeEndTimePart(DateTime startTime, DateTime endTime) {
        return this.buildTimePart(startTime, endTime);
    }

    public String alarmIdsPart(List<String> alarmIdList) {
        return this.buildAlarmsPart(alarmIdList);
    }

    public String periodPartWithGroupBy(int period) {
        return period > 0 ? String.format(" group by time(%1$ds), * fill(0)", period) : " group by time(300s), * fill(0)";
    }

    public String periodPart(int period) {
        return period > 0 ? String.format(" group by time(%1$ds) fill(0)", period) : " group by time(300s) fill(0)";
    }

    Map<String, String> filterPrivateTags(Map<String, String> tagMap) {
        HashMap<String, String> filteredMap = new HashMap<String, String>(tagMap);
        filteredMap.remove("_tenant_id");
        filteredMap.remove("_region");
        return filteredMap;
    }

    public String threeDigitMillisTimestamp(String origTimestamp) {
        String timestamp;
        int length = origTimestamp.length();
        if (length == 20) {
            timestamp = origTimestamp.substring(0, 19) + ".000Z";
        } else {
            String millisecond = origTimestamp.substring(20, length - 1);
            String millisecond_3d = StringUtils.rightPad((String)millisecond, (int)3, (char)'0');
            timestamp = origTimestamp.substring(0, 19) + '.' + millisecond_3d + 'Z';
        }
        return timestamp;
    }

    public List<String> parseMultiOffset(String offsetStr) {
        return offsetSplitter.splitToList((CharSequence)offsetStr);
    }

    public Map<String, String> getDimensions(String[] vals, String[] cols) {
        HashMap<String, String> dims = new HashMap<String, String>();
        for (int i = 0; i < cols.length; ++i) {
            if (cols[i].startsWith(OFFSET_SEPARATOR) || vals[i].equalsIgnoreCase("null")) continue;
            dims.put(cols[i], vals[i]);
        }
        return dims;
    }
}

