/*
 * Decompiled with CFR 0.152.
 */
package monasca.api.infrastructure.persistence.influxdb;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.inject.Inject;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import monasca.api.ApiConfig;
import monasca.api.domain.model.metric.MetricDefinitionRepo;
import monasca.api.domain.model.metric.MetricName;
import monasca.api.infrastructure.persistence.influxdb.InfluxV9RepoReader;
import monasca.api.infrastructure.persistence.influxdb.InfluxV9Utils;
import monasca.api.infrastructure.persistence.influxdb.Serie;
import monasca.api.infrastructure.persistence.influxdb.Series;
import monasca.common.model.metric.MetricDefinition;
import org.joda.time.DateTime;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InfluxV9MetricDefinitionRepo
implements MetricDefinitionRepo {
    private static final Logger logger = LoggerFactory.getLogger(InfluxV9MetricDefinitionRepo.class);
    private final ApiConfig config;
    private final InfluxV9RepoReader influxV9RepoReader;
    private final InfluxV9Utils influxV9Utils;
    private final String region;
    private final ObjectMapper objectMapper = new ObjectMapper();

    @Inject
    public InfluxV9MetricDefinitionRepo(ApiConfig config, InfluxV9RepoReader influxV9RepoReader, InfluxV9Utils influxV9Utils) {
        this.config = config;
        this.region = config.region;
        this.influxV9RepoReader = influxV9RepoReader;
        this.influxV9Utils = influxV9Utils;
    }

    boolean isAtMostOneSeries(String tenantId, String name, Map<String, String> dimensions) throws Exception {
        String q = String.format("show series %1$s where %2$s %3$s %4$s limit 2", this.influxV9Utils.namePart(name, false), this.influxV9Utils.privateTenantIdPart(tenantId), this.influxV9Utils.privateRegionPart(this.region), this.influxV9Utils.dimPart(dimensions));
        logger.debug("Metric definition query: {}", (Object)q);
        String r = this.influxV9RepoReader.read(q);
        Series series = (Series)this.objectMapper.readValue(r, Series.class);
        List<MetricDefinition> metricDefinitionList = this.metricDefinitionList(series, tenantId, name, null, null, 0);
        logger.debug("Found {} metric definitions matching query", (Object)metricDefinitionList.size());
        return metricDefinitionList.size() <= 1;
    }

    @Override
    public List<MetricDefinition> find(String tenantId, String name, Map<String, String> dimensions, DateTime startTime, DateTime endTime, String offset, int limit) throws Exception {
        int startIndex = this.influxV9Utils.startIndex(offset);
        String q = String.format("show series %1$s where %2$s %3$s %4$s %5$s %6$s", this.influxV9Utils.namePart(name, false), this.influxV9Utils.privateTenantIdPart(tenantId), this.influxV9Utils.privateRegionPart(this.region), this.influxV9Utils.dimPart(dimensions), this.influxV9Utils.limitPart(limit), this.influxV9Utils.offsetPart(startIndex));
        logger.debug("Metric definition query: {}", (Object)q);
        String r = this.influxV9RepoReader.read(q);
        Series series = (Series)this.objectMapper.readValue(r, Series.class);
        List<MetricDefinition> metricDefinitionList = this.metricDefinitionList(series, tenantId, name, startTime, endTime, startIndex);
        logger.debug("Found {} metric definitions matching query", (Object)metricDefinitionList.size());
        return metricDefinitionList;
    }

    @Override
    public List<MetricName> findNames(String tenantId, Map<String, String> dimensions, String offset, int limit) throws Exception {
        int startIndex = this.influxV9Utils.startIndex(offset);
        String q = String.format("show measurements where %1$s %2$s %3$s %4$s %5$s", this.influxV9Utils.privateTenantIdPart(tenantId), this.influxV9Utils.privateRegionPart(this.region), this.influxV9Utils.dimPart(dimensions), this.influxV9Utils.limitPart(limit), this.influxV9Utils.offsetPart(startIndex));
        logger.debug("Metric name query: {}", (Object)q);
        String r = this.influxV9RepoReader.read(q);
        Series series = (Series)this.objectMapper.readValue(r, Series.class);
        List<MetricName> metricNameList = this.metricNameList(series, startIndex);
        logger.debug("Found {} metric definitions matching query", (Object)metricNameList.size());
        return metricNameList;
    }

    private List<MetricDefinition> metricDefinitionList(Series series, String tenantId, String name, DateTime startTime, DateTime endTime, int startIndex) {
        ArrayList<MetricDefinition> metricDefinitionList = new ArrayList<MetricDefinition>();
        if (!series.isEmpty()) {
            int index = startIndex;
            for (Serie serie : series.getSeries()) {
                for (String[] values : serie.getValues()) {
                    MetricDefinition m = new MetricDefinition(serie.getName(), this.influxV9Utils.getDimensions(values, serie.getColumns()));
                    if (!this.hasMeasurements(m, tenantId, startTime, endTime)) continue;
                    m.setId(String.valueOf(index++));
                    metricDefinitionList.add(m);
                }
            }
        }
        return metricDefinitionList;
    }

    private List<MetricName> metricNameList(Series series, int startIndex) {
        ArrayList<MetricName> metricNameList = new ArrayList<MetricName>();
        if (!series.isEmpty()) {
            int index = startIndex;
            Serie serie = series.getSeries()[0];
            for (String[] values : serie.getValues()) {
                MetricName m = new MetricName(String.valueOf(index++), values[0]);
                metricNameList.add(m);
            }
        }
        return metricNameList;
    }

    private boolean hasMeasurements(MetricDefinition m, String tenantId, DateTime startTime, DateTime endTime) {
        boolean hasMeasurements = true;
        if (startTime == null) {
            return hasMeasurements;
        }
        try {
            String q = this.buildMeasurementsQuery(tenantId, m.name, m.dimensions, startTime, endTime);
            String r = this.influxV9RepoReader.read(q);
            Series series = (Series)this.objectMapper.readValue(r, Series.class);
            hasMeasurements = !series.isEmpty();
        }
        catch (Exception e) {
            logger.error("Failed to query for measuremnts for: {}", (Object)m.name, (Object)e);
            hasMeasurements = true;
        }
        return hasMeasurements;
    }

    private String buildMeasurementsQuery(String tenantId, String name, Map<String, String> dimensions, DateTime startTime, DateTime endTime) throws Exception {
        String q = String.format("select value, value_meta %1$s where %2$s %3$s %4$s %5$s %6$s %7$s slimit 1", this.influxV9Utils.namePart(name, true), this.influxV9Utils.privateTenantIdPart(tenantId), this.influxV9Utils.privateRegionPart(this.region), this.influxV9Utils.startTimePart(startTime), this.influxV9Utils.dimPart(dimensions), this.influxV9Utils.endTimePart(endTime), this.influxV9Utils.groupByPart());
        logger.debug("Measurements query: {}", (Object)q);
        return q;
    }
}

