/*
 * Decompiled with CFR 0.152.
 */
package monasca.api.infrastructure.persistence.hibernate;

import com.google.common.collect.Lists;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.UUID;
import javax.inject.Inject;
import javax.inject.Named;
import monasca.api.domain.exception.EntityExistsException;
import monasca.api.domain.exception.EntityNotFoundException;
import monasca.api.domain.model.notificationmethod.NotificationMethod;
import monasca.api.domain.model.notificationmethod.NotificationMethodRepo;
import monasca.api.infrastructure.persistence.hibernate.BaseSqlRepo;
import monasca.api.resource.exception.Exceptions;
import monasca.common.hibernate.db.NotificationMethodDb;
import monasca.common.model.alarm.AlarmNotificationMethodType;
import org.apache.commons.collections4.CollectionUtils;
import org.hibernate.Query;
import org.hibernate.Session;
import org.hibernate.SessionFactory;
import org.hibernate.Transaction;
import org.joda.time.DateTime;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NotificationMethodSqlRepoImpl
extends BaseSqlRepo
implements NotificationMethodRepo {
    private static final Logger LOG = LoggerFactory.getLogger(NotificationMethodSqlRepoImpl.class);

    @Inject
    public NotificationMethodSqlRepoImpl(@Named(value="orm") SessionFactory sessionFactory) {
        super(sessionFactory);
    }

    @Override
    public NotificationMethod create(String tenantId, String name, String notificationMethodType, String address, int period) {
        Transaction tx = null;
        try (Session session = null;){
            session = this.sessionFactory.openSession();
            tx = session.beginTransaction();
            if (this.byTenantIdAndName(session, tenantId, name) != null) {
                throw new EntityExistsException("Notification method %s \"%s\" already exists.", tenantId, name);
            }
            String id = UUID.randomUUID().toString();
            DateTime now = this.getUTCNow();
            NotificationMethodDb db = new NotificationMethodDb(id, tenantId, name, AlarmNotificationMethodType.valueOf((String)notificationMethodType), address, Integer.valueOf(period), now, now);
            session.save((Object)db);
            LOG.debug("Creating notification method {} for {}", (Object)name, (Object)tenantId);
            tx.commit();
            tx = null;
            NotificationMethod notificationMethod = this.convertToNotificationMethod(db);
            return notificationMethod;
        }
    }

    @Override
    public void deleteById(String tenantId, String notificationMethodId) {
        Transaction tx = null;
        try (Session session = null;){
            if (!this.exists(tenantId, notificationMethodId)) {
                throw new EntityNotFoundException("No notification exists for %s", notificationMethodId);
            }
            session = this.sessionFactory.openSession();
            tx = session.beginTransaction();
            session.getNamedQuery("NotificationMethod.deleteById").setString("id", notificationMethodId).executeUpdate();
            tx.commit();
            tx = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean exists(String tenantId, String notificationMethodId) {
        try (Session session = null;){
            session = this.sessionFactory.openSession();
            boolean bl = this.getByTenantIdAndId(session, tenantId, notificationMethodId) != null;
            return bl;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public NotificationMethod findById(String tenantId, String notificationMethodId) {
        try (Session session = null;){
            session = this.sessionFactory.openSession();
            NotificationMethodDb result = this.getByTenantIdAndId(session, tenantId, notificationMethodId);
            if (result == null) {
                throw new EntityNotFoundException("No notification method exists for %s", notificationMethodId);
            }
            NotificationMethod notificationMethod = this.convertToNotificationMethod(result);
            return notificationMethod;
        }
    }

    @Override
    public NotificationMethod update(String tenantId, String notificationMethodId, String name, String notificationMethodType, String address, int period) {
        Transaction tx = null;
        try (Session session = null;){
            session = this.sessionFactory.openSession();
            NotificationMethodDb result = this.byTenantIdAndName(session, tenantId, name);
            if (result != null && !((String)((Object)result.getId())).equalsIgnoreCase(notificationMethodId)) {
                throw new EntityExistsException("Notification method %s \"%s\" already exists.", tenantId, name);
            }
            tx = session.beginTransaction();
            NotificationMethodDb db = (NotificationMethodDb)session.get(NotificationMethodDb.class, (Serializable)((Object)notificationMethodId));
            if (db == null) {
                throw new EntityNotFoundException("No notification method exists for %s", notificationMethodId);
            }
            db.setName(name);
            db.setType(AlarmNotificationMethodType.valueOf((String)notificationMethodType));
            db.setAddress(address);
            db.setPeriod(Integer.valueOf(period));
            db.setUpdatedAt(this.getUTCNow());
            session.save((Object)db);
            tx.commit();
            tx = null;
            NotificationMethod notificationMethod = this.convertToNotificationMethod(db);
            return notificationMethod;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<NotificationMethod> find(String tenantId, List<String> sortBy, String offset, int limit) {
        if (sortBy != null && !sortBy.isEmpty()) {
            throw Exceptions.unprocessableEntity("Sort_by is not implemented for the hibernate database type", new Object[0]);
        }
        Session session = null;
        ArrayList notificationList = Lists.newArrayList();
        String rawQuery = "from NotificationMethodDb where tenant_id = :tenantId %1$s order by id";
        try {
            List resultList;
            session = this.sessionFactory.openSession();
            String offsetPart = offset != null ? String.format("and id > '%s'", offset) : "";
            String queryHql = String.format("from NotificationMethodDb where tenant_id = :tenantId %1$s order by id", offsetPart);
            Query query = session.createQuery(queryHql).setString("tenantId", tenantId);
            if (limit > 0) {
                query.setMaxResults(limit + 1);
            }
            if (CollectionUtils.isEmpty((Collection)(resultList = query.list()))) {
                ArrayList arrayList = notificationList;
                return arrayList;
            }
            for (NotificationMethodDb item : resultList) {
                notificationList.add(this.convertToNotificationMethod(item));
            }
            ArrayList arrayList = notificationList;
            return arrayList;
        }
        finally {
            if (session != null) {
                session.close();
            }
        }
    }

    protected NotificationMethodDb byTenantIdAndName(Session session, String tenantId, String name) {
        return (NotificationMethodDb)session.getNamedQuery("NotificationMethod.finByTenantIdAndName").setString("tenantId", tenantId).setString("name", name).uniqueResult();
    }

    protected NotificationMethodDb getByTenantIdAndId(Session session, String tenantId, String id) {
        return (NotificationMethodDb)session.getNamedQuery("NotificationMethod.findByTenantIdAndId").setString("tenantId", tenantId).setString("id", id).uniqueResult();
    }

    protected NotificationMethod convertToNotificationMethod(NotificationMethodDb db) {
        return db == null ? null : new NotificationMethod((String)((Object)db.getId()), db.getName(), db.getType().toString(), db.getAddress(), db.getPeriod());
    }
}

