/*
 * Decompiled with CFR 0.152.
 */
package monasca.api.infrastructure.persistence.hibernate;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.inject.Inject;
import javax.inject.Named;
import monasca.api.infrastructure.persistence.Utils;
import monasca.api.infrastructure.persistence.hibernate.BaseSqlRepo;
import org.hibernate.Query;
import org.hibernate.SessionFactory;
import org.hibernate.StatelessSession;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AlarmHibernateUtils
extends Utils {
    private static final Logger logger = LoggerFactory.getLogger(AlarmHibernateUtils.class);
    private static final String FIND_ALARM_IDS_SQL = "select distinct a.id, ad.created_at from alarm as a join alarm_definition as ad on a.alarm_definition_id = ad.id %s where ad.tenant_id = :tenantId and ad.deleted_at is NULL order by ad.created_at";
    private final SessionFactory sessionFactory;

    @Inject
    public AlarmHibernateUtils(@Named(value="orm") SessionFactory sessionFactory) {
        this.sessionFactory = sessionFactory;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<String> findAlarmIds(String tenantId, Map<String, String> dimensions) {
        logger.trace(BaseSqlRepo.ORM_LOG_MARKER, "findAlarmIds(...) entering");
        ArrayList alarmIdList = null;
        try (StatelessSession session = null;){
            session = this.sessionFactory.openStatelessSession();
            String sql = this.findAlarmQueryString(dimensions);
            Query query = session.createSQLQuery(sql).setString("tenantId", tenantId);
            this.bindDimensionsToQuery(query, dimensions);
            List rows = query.list();
            alarmIdList = Lists.newArrayListWithCapacity((int)rows.size());
            for (Object[] row : rows) {
                String id = (String)row[0];
                alarmIdList.add(id);
            }
        }
        return alarmIdList;
    }

    private String findAlarmQueryString(Map<String, String> dimensions) {
        return String.format(FIND_ALARM_IDS_SQL, this.buildJoinClauseFor(dimensions));
    }

    private void bindDimensionsToQuery(Query query, Map<String, String> dimensions) {
        if (dimensions != null) {
            int i = 0;
            for (Map.Entry<String, String> entry : dimensions.entrySet()) {
                query.setString("dname" + i, entry.getKey());
                query.setString("dvalue" + i, entry.getValue());
                ++i;
            }
        }
    }
}

